% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add-methods.R
\name{add_fitted}
\alias{add_fitted}
\title{Add fitted values from a model to a data frame}
\usage{
add_fitted(data, model, value = ".value", ...)
}
\arguments{
\item{data}{a data frame containing values for the variables used to fit the
model. Passed to \code{\link[stats:predict]{stats::predict()}} as \code{newdata}.}

\item{model}{a fitted model for which a \code{\link[stats:predict]{stats::predict()}} method is
available. S3 method dispatch is performed on the \code{model} argument.}

\item{value}{character; the name of the variable in which model predictions
will be stored.}

\item{...}{additional arguments passed to methods.}
}
\value{
A data frame (tibble) formed from \code{data} and fitted values from
\code{model}.
}
\description{
Add fitted values from a model to a data frame
}
