% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_flights.R
\name{plotFlights}
\alias{plotFlights}
\title{Plot flight data}
\usage{
plotFlights(
  airportIndices = NULL,
  airports_sel = NULL,
  connections_sel = NULL,
  graph = NULL,
  plotAirports = TRUE,
  plotConnections = TRUE,
  labelAirports = FALSE,
  returnGGPlot = FALSE,
  useAirportNFlights = FALSE,
  useConnectionNFlights = FALSE,
  minNFlights = 0,
  map = "state",
  vertexColors = NULL,
  vertexShapes = NULL,
  edgeColors = NULL,
  xyRatio = NULL,
  clipMap = FALSE,
  useLatex = FALSE,
  edgeAlpha = 0.2
)
}
\arguments{
\item{airportIndices}{The indices of the airports (w.r.t. \code{airports_sel}) to include.}

\item{airports_sel}{The airports to plot. Might be further subset by arguments \code{airportIndices}, \code{graph}.
If \code{NULL}, then \code{\link{flights}}\verb{$airports} will be used.}

\item{connections_sel}{A three columns data frame as output by \code{\link[=flightCountMatrixToConnectionList]{flightCountMatrixToConnectionList()}}.
If \code{NULL}, then \code{\link{flights}}\verb{$nFlights} will be used to construct one.}

\item{graph}{An optional \code{\link[igraph:make_graph]{igraph::graph}} object, containing a flight graph to plot.
Vertices should either match the selected airports in number and order,
or be named with the corresponding IATA codes of the airports they represent.}

\item{plotAirports}{Logical. Whether to plot the airports specified.}

\item{plotConnections}{Logical. Whether to plot the connections specified.}

\item{labelAirports}{Logical. Whether to show the IATA code next to each plotted airport.}

\item{returnGGPlot}{If \code{TRUE}, a \code{\link[ggplot2:ggplot]{ggplot2::ggplot}} object is returned and not plotted immediately.}

\item{useAirportNFlights}{Logical. Whether to vary the size of the circles representing airports in the plot,
according to the number of flights at that airport.}

\item{useConnectionNFlights}{Logical. Whether to vary the size of the edges representing connections in the plot,
according to the number of flights on that connection.}

\item{minNFlights}{Numeric scalar. Only plot connections with at least this many flights.}

\item{map}{String or \code{\link{data.frame}} or \code{NULL}. What map to use as the background image.
Strings are passed to \code{\link[ggplot2:map_data]{ggplot2::map_data()}}, data frames are assumed to be the output of \code{\link[ggplot2:map_data]{ggplot2::map_data()}}.}

\item{vertexColors}{Optional vector, named with IATA codes, to be used as colors for the vertices/airports.}

\item{vertexShapes}{Optional vector, named with IATA codes, to be used as shapes for the vertices/airports. Is coerced to \code{character}.}

\item{edgeColors}{Optional vector or symmetric matrix (character or numeric), to be used as colors for edges/connections.
If this is a vector, its entries must match the plotted connections (in the order specified in \code{connections_sel} or implied by \code{\link[igraph:as_edgelist]{igraph::get.edgelist}}).
If this is a matrix, its row/column names must be IATA codes, or its rows/columns match the plotted airports (in number and order).}

\item{xyRatio}{Approximate X-Y-ratio (w.r.t. distance on the ground) of the area shown in the plot.}

\item{clipMap}{Logical or numeric scalar. Whether to ignore the map image when determining the axis limits of the plot.
If it is a positive scalar, the plot limits are extended by that factor.}

\item{useLatex}{Whether to format numbers etc. as latex code (useful when plotting to tikz).}

\item{edgeAlpha}{Numeric scalar between 0 and 1. The alpha value to be used when plotting edges/connections.}
}
\value{
If \code{returnGGPlot} is \code{TRUE}, a \code{\link[ggplot2:ggplot]{ggplot2::ggplot}} object, otherwise \code{NULL}.
}
\description{
Plotting function to visualize the flight connections from the \code{\link{flights}} dataset.
This function requires the package \code{ggplot2} to be installed.
}
\examples{
# Plot all airports in the dataset
plotFlights(plotConnections = FALSE, map = 'world')

# Plot a selection of airports
plotFlights(c('JFK', 'SFO', 'LAX'), useConnectionNFlights = TRUE, useAirportNFlights = TRUE)

# Plot airports with a custom connections graph
IATAs <- c('ACV', 'BFL', 'EUG', 'SFO', 'MRY')
graph <- igraph::make_full_graph(length(IATAs))
plotFlights(IATAs, graph=graph, clipMap = 1.5)

}
\seealso{
\code{\link{plotDanube}}

Other flight data related topics:
\code{\link{flightCountMatrixToConnectionList}()},
\code{\link{flights}},
\code{\link{getFlightDelayData}()},
\code{\link{getFlightGraph}()}
}
\concept{flightData}
