% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diagnostics.R
\name{PlotConversionFreq}
\alias{PlotConversionFreq}
\title{Diagnostic plot for conversion frequencies}
\usage{
PlotConversionFreq(data, category, sample = NULL, max.columns = 120)
}
\arguments{
\item{data}{the grandR object}

\item{category}{show a specific category (see \link{GetDiagnosticParameters}); cannot be NULL}

\item{sample}{compare subreads for a specific sample; can be NULL, then compare all samples per subread}

\item{max.columns}{if there are more columns (samples for bulk, cells for single cell) than this, show boxplots instead of points}
}
\value{
a list with a ggplot object, a description, and the desired size for the plot
}
\description{
This is the second diagnostic plot (estimated conversions) generated by GRAND3.
}
\details{
Show the percentage of all conversion types for all samples. In contrast to mismatches
(see \link{PlotMismatchPositionForSample} and \link{PlotMismatchPositionForType}),
the correct strand is already inferred for conversions, i.e. conversions refer to
actual conversion events on RNA, whereas mismatches are observed events in mapped reads.
}
\concept{diagnostics}
