% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_bar_sd.R
\name{plot_bar_sd}
\alias{plot_bar_sd}
\title{Plot a bar graph indicating mean with error bars (SD) using two variables.}
\usage{
plot_bar_sd(
  data,
  xcol,
  ycol,
  b_alpha = 1,
  bwid = 0.7,
  bthick = 1,
  ewid = 0.3,
  ColPal = c("okabe_ito", "all_grafify", "bright", "contrast", "dark", "fishy",
    "kelly", "light", "muted", "pale", "r4", "safe", "vibrant"),
  ColSeq = TRUE,
  ColRev = FALSE,
  SingleColour = "NULL",
  TextXAngle = 0,
  fontsize = 20,
  ...
)
}
\arguments{
\item{data}{a data table object, e.g. a data.frame or tibble.}

\item{xcol}{name of the column to plot on X axis. This should be a categorical variable.}

\item{ycol}{name of the column to plot on the Y axis. This should be a quantitative variable.}

\item{b_alpha}{fractional opacity of bars, default set to 1 (i.e. maximum opacity & zero transparency).}

\item{bwid}{width of bars, default 0.7}

\item{bthick}{thickness of bar borders; default 1.}

\item{ewid}{width of error bars, default 0.3}

\item{ColPal}{grafify colour palette to apply, default "okabe_ito"; see \code{\link{graf_palettes}} for available palettes.}

\item{ColSeq}{logical TRUE or FALSE. Default TRUE for sequential colours from chosen palette. Set to FALSE for distant colours, which will be applied using  \code{scale_fill_grafify2}.}

\item{ColRev}{whether to reverse order of colour within the selected palette, default F (FALSE); can be set to T (TRUE).}

\item{SingleColour}{a colour hexcode (starting with #), a number between 1-154, or names of colours from \code{grafify} colour palettes to fill along X-axis aesthetic. Accepts any colour other than "black"; use \code{grey_lin11}, which is almost black.}

\item{TextXAngle}{orientation of text on X-axis; default 0 degrees. Change to 45 or 90 to remove overlapping text.}

\item{fontsize}{parameter of \code{base_size} of fonts in \code{theme_classic}, default set to size 20.}

\item{...}{any additional arguments to pass to \code{stat_summary}.}
}
\value{
This function returns a \code{ggplot2} object of class "gg" and "ggplot".
}
\description{
This function takes a data table, categorical X and numeric Y variables, and plots bars showing the mean with SD error bars. The X variable is mapped to the \code{fill} aesthetic of bars. The related \code{plot_bar_sd_sc} plots bars with a single colour.
}
\details{
The function uses \code{\link[ggplot2]{stat_summary}} with \code{geom = "bar"}. Standard deviation (SD) is plotted through \code{\link[ggplot2]{stat_summary}} calculated using \code{mean_sdl} from the \code{ggplot2} package (get help with \code{?mean_sdl}), and 1x SD is plotted (\code{fun.arg = list(mult = 1)}.

Colours can be changed using \code{ColPal}, \code{ColRev} or \code{ColSeq} arguments. Colours available can be seen quickly with \code{\link{plot_grafify_palette}}.
\code{ColPal} can be one of the following: "okabe_ito", "dark", "light", "bright", "pale", "vibrant,  "muted" or "contrast".
\code{ColRev} (logical TRUE/FALSE) decides whether colours are chosen from first-to-last or last-to-first from within the chosen palette.
\code{ColSeq} decides whether colours are picked by respecting the order in the palette or the most distant ones using \code{\link[grDevices]{colorRampPalette}}.

If there are many groups along the X axis and you prefer a single colour for the graph,use the \code{SingleColour} argument.

You are instead encouraged to show all data using the following functions: \code{\link{plot_scatterbar_sd}}, \code{\link{plot_scatterbox}}, \code{\link{plot_dotbox}}, \code{\link{plot_dotbar_sd}}, \code{\link{plot_scatterviolin}} or \code{\link{plot_dotviolin}}.
}
\examples{

#Basic usage
plot_bar_sd(data = data_doubling_time, 
xcol = Student, ycol = Doubling_time)

#apply distant colours in the default palette
plot_bar_sd(data = data_doubling_time, 
xcol = Student, ycol = Doubling_time, 
ColSeq = FALSE)

#single colour along X axis aesthetic
plot_bar_sd(data = data_doubling_time, 
xcol = Student, ycol = Doubling_time, 
SingleColour = "pale_cyan")

}
