% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gradDescentR.Methods.R
\name{RMSPROP}
\alias{RMSPROP}
\title{ADADELTA Method Learning Function}
\usage{
RMSPROP(dataTrain, alpha = 0.1, maxIter = 10, momentum = 0.9,
  seed = NULL)
}
\arguments{
\item{dataTrain}{a data.frame that representing training data (\eqn{m \times n}),
where \eqn{m} is the number of instances and \eqn{n} is the number
of variables where the last column is the output variable. dataTrain
must have at least two columns and ten rows of data that contain
only numbers (integer or float).}

\item{alpha}{a float value representing learning rate. Default value is 0.1}

\item{maxIter}{the maximal number of iterations.}

\item{momentum}{a float value represent momentum give a constant speed to learning process.}

\item{seed}{a integer value for static random. Default value is NULL, which means
the function will not do static random.}
}
\value{
a vector matrix of theta (coefficient) for linear model.
}
\description{
A function to build prediction model using RMSPROP method.
}
\details{
This function based on \code{\link{SGD}} with an optimization to create
an adaptive learning rate by RMS cost and hessian approximation correction approach.
In other word, this method combine the \code{\link{ADAGRAD}} and \code{\link{ADADELTA}}
approaches.
}
\examples{
##################################
## Learning and Build Model with RMSPROP
## load R Package data
data(gradDescentRData)
## get z-factor data
dataSet <- gradDescentRData$CompressilbilityFactor
## split dataset
splitedDataSet <- splitData(dataSet)
## build model with RMSPROP
RMSPROPmodel <- RMSPROP(splitedDataSet$dataTrain)
#show result
print(RMSPROPmodel)

}
\references{
M. D. Zeiler
Adadelta: An Adaptive Learning Rate Method,
arXiv: 1212.5701v1,
pp. 1-6 (2012)
}
\seealso{
\code{\link{ADAGRAD}}, \code{\link{ADADELTA}}, \code{\link{ADAM}}
}
