% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gradDescent.MainFunction.R
\name{gradDescent.learn}
\alias{gradDescent.learn}
\title{the gradDescent model building function}
\usage{
gradDescent.learn(gradDescent.data, methodType = "GD", alpha = 0.1,
  maxIter = 10, shuffle = FALSE, batchRate = 1, momentum = 0,
  accelerate = FALSE, stochastic = FALSE, smooth = 1e-07, delay = 0,
  seed = NULL)
}
\arguments{
\item{gradDescent.data}{a object that created exclusively from 
gradDescent.preprocessing function.}

\item{methodType}{this parameter determine the learning algorithm
       to be used. The default method is "GD".
       The Following methods are implemented:
\itemize{
\item \code{"GD"}: Gradient descent method to calculate gradient.
\item \code{"SAG"}: Stochastic Average gradient descent method to calculate gradient.
\item \code{"ADAGRAD"} : Adaptive Subgradient method to calculate gradient.
\item \code{"ADADELTA"} : Adadelta method to calculate gradient.
\item \code{"RMSPROP"} : RMSprop method to calculate gradient.
\item \code{"ADAM"} : Adaptive Moment Estimation method to calculate gradient.
}}

\item{alpha}{a float value for learning rate. Default value is 0.1}

\item{maxIter}{a integer value for maximum iteration for learning. Default 
value is 10.}

\item{shuffle}{a boolean value to shuffle data. Default value is TRUE, which means
the data will be shuffled before the learning.}

\item{batchRate}{a float value for batch size of data that will used for learning.
batchRate must be more or equal to 0.1 and least or equal to 1. Default value
is 1, which means will process all data train.}

\item{momentum}{a float value to give a constant speed to learning process.
Default value is 0, which means learning has no momentum.}

\item{accelerate}{a boolean value to enable accelerate in the learning with momentum.
If the the momentum set to 0, there will be no accelerate. Default value is TRUE,
which means the learning process do the accelerate.}

\item{stochastic}{a boolean value to enable stochastic, which mean to select one random
value in data train, instead process all data train. Default value is TRUE,  
which means the learning will do the stochastic.}

\item{smooth}{a float value to handle zero division issue in certain learning method.
Default value is 0.0000001.}

\item{delay}{a float value represent time second to give extra-time in iterations.}

\item{seed}{a integer value for static random. Default value is NULL, which means 
the function will not do static random.}
}
\description{
This is the second and central main function to build a prediction
model with various gradient descent algorithms using data object
that created from gradDescent.preprocessing function. The model and
used parameter will be wrapped into a class.
}
\examples{
##################################
## I. Build model with Gradient Descent Method
square_feet <- c(1400,1600,1700,1875,1100,1550,2350,2450,1425,1700)

price <- c(245,312,279,308,199,219,405,324,319,255)

house_price <- data.frame(square_feet, price)

## do the preprocessing stage
house_price.data <- gradDescent.preprocessing(
      house_price,
      normalizationMethod="variance"
   )

## do the model building stage
GD.model <- gradDescent.learn(
      house_price.data,
      methodType="GD" 
   )


##################################
## II. Build model with Accelerated-Momentum Gradient Descent Method
square_feet <- c(1400,1600,1700,1875,1100,1550,2350,2450,1425,1700)

price <- c(245,312,279,308,199,219,405,324,319,255)

house_price <- data.frame(square_feet, price)

## do the preprocessing stage
house_price.data <- gradDescent.preprocessing(
      house_price,
      normalizationMethod="variance"
   )

## do the model building stage
GD.model <- gradDescent.learn(
      house_price.data,
      momentum=0.9,
      accelerate=TRUE
   )

}

