% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/azure-openai.R
\name{create_completion_azure_openai}
\alias{create_completion_azure_openai}
\title{Generate text using Azure OpenAI's API}
\usage{
create_completion_azure_openai(
  prompt,
  task = Sys.getenv("AZURE_OPENAI_TASK"),
  base_url = Sys.getenv("AZURE_OPENAI_ENDPOINT"),
  deployment_name = Sys.getenv("AZURE_OPENAI_DEPLOYMENT_NAME"),
  token = Sys.getenv("AZURE_OPENAI_KEY"),
  api_version = Sys.getenv("AZURE_OPENAI_API_VERSION")
)
}
\arguments{
\item{prompt}{a list to use as the prompt for generating
completions}

\item{task}{a character string for the API task. Defaults to the Azure OpenAI
task from environment variables if not specified.}

\item{base_url}{a character string for the base url. It defaults to the Azure
OpenAI endpoint from environment variables if not specified.}

\item{deployment_name}{a character string for the deployment name. It will
default to the Azure OpenAI deployment name from environment variables if
not specified.}

\item{token}{a character string for the API key. It will default to the Azure
OpenAI API key from your environment variables if not specified.}

\item{api_version}{a character string for the API version. It will default to
the Azure OpenAI API version from your environment variables if not
specified.}
}
\value{
a list with the generated completions and other information returned
by the API
}
\description{
Use this function to generate text completions using OpenAI's
API.
}
\examples{
\dontrun{
create_completion_azure_openai(
  prompt = list(list(role = "user", content = "Hello world!"
)
}

}
