% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dispatchers.R
\name{param}
\alias{param}
\alias{get_param}
\alias{set_param}
\title{Get or set GP model parameters}
\usage{
get_param(object, ...)

set_param(object, param, ...)
}
\arguments{
\item{object}{The model object.}

\item{...}{Ignored currently.}

\item{param}{The parameters to be set. Call first \code{get_param} to see the order in which the parameters should be given for a particular model. Notice that all positive parameters should be given in a log-scale.}
}
\value{
\code{get_param} returns the current hyperparameters and \code{set_param} the GP model structure with the new parameter values.
}
\description{
\code{get_param} returns the current hyperparameters of the GP model in a vector.
\code{set_param} can be used to set the parameters. Note that these functions
are intended mainly for internal usage, and there is typically
no need to use these functions directly but instead create a new GP model using
\code{gp_init}.
}
\examples{

# Set up some model
gp <- gp_init(cf = cf_sexp(), lik = lik_gaussian())

# print out to see the parameter ordering
param <- get_param(gp)
print(param)

# set some new values
param_new <- log(c(0.1, 0.8, 0.3))
names(param_new) <- names(param)
gp <- set_param(gp, param_new)

# check the result
print(get_param(gp))


}
