% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gower.R
\name{gower.agree}
\alias{gower.agree}
\title{Apply the Bayesian Gower agreement methodology to nominal or ordinal data.}
\usage{
gower.agree(
  data,
  data.type = c("nominal", "ordinal"),
  dist.type = c("mean", "max"),
  design = c("one-way", "two-way"),
  iter = 10000,
  ...
)
}
\arguments{
\item{data}{a matrix of scores. Each row corresponds to a unit, each column to a coder.}

\item{data.type}{the type of scores to be analyzed, either \code{"nominal"} or \code{"ordinal"}.}

\item{dist.type}{for ordinal data, whether the row statistics are computed using the mean of the pairwise distances or the maximum pairwise distance.}

\item{design}{the sampling design, either \code{"one-way"} or \code{"two-way"}. For the former, the units are random and the coders are fixed. For the latter, both the units and the coders are random.}

\item{iter}{the desired size of the posterior sample. The default value is 10,000.}

\item{\dots}{additional arguments for the distance function. These are ignored for nominal data. For ordinal data the range of the scores must be provided via argument \code{range}.}
}
\value{
Function \code{gower.agree} returns an object of class \code{"gower"}, which is a list comprising the following elements.
        \item{mu.hat}{the estimate of the posterior mean.}
        \item{mu.sample}{the posterior sample.}
        \item{call}{the matched call.}
        \item{units}{the number of units.}
        \item{coders}{the number of coders.}
        \item{data}{the data matrix, sans rows that were removed due to missigness.}
        \item{data.type}{the type of scores, nominal or ordinal.}
        \item{dist.type}{for ordinal data, the manner in which the row statistics were computed.}
        \item{design}{the sampling design, one-way or two-way.}
        \item{row.stats}{the vector of row statistics.}
        \item{del}{the number of rows that were deleted due to missingness.}
}
\description{
Apply the Bayesian Gower agreement methodology to nominal or ordinal data.
}
\details{
This is the package's flagship function. It applies the Bayesian Gower methodology to nominal or ordinal data, and provides an estimate of the posterior mean along with a credible interval.
}
\examples{

# Fit the liver data, using the mean distance for each row of the data matrix.
# The range (which is equal to 4) must be passed to \code{\link{gower.agree}}
# since these data are ordinal and the L1 distance function is used. We assume
# a one-way sampling design for these data, i.e., units are random and coders
# are fixed.

data(liver)
liver = as.matrix(liver)
fit = gower.agree(liver, data.type = "ordinal", range = 4)
summary(fit)
}
