% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rowbind.R
\name{rowbind}
\alias{rowbind}
\alias{rowbind.default}
\alias{rowbind.list}
\title{Combine R objects by rows}
\usage{
rowbind(x, ...)

\method{rowbind}{default}(x, y, ...)

\method{rowbind}{list}(x, ...)
}
\arguments{
\item{x}{a R object, typically a data.frame, matrix or list}

\item{...}{additional arguments passed to methods}

\item{y}{a matrix, a data.frame (or any other object that can
be coerced to data.frame)}
}
\value{
a data.frame with the combined data
}
\description{
Combine R objects when number and names of columns do not match
}
\examples{
 
# two data frames
rowbind(airquality, mtcars)

# a list of data frames
l <- list(airquality, mtcars)
rowbind(l)

}
\concept{utility functions}
