% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/google_map_layer_marker.R
\name{add_markers}
\alias{add_markers}
\title{Add markers}
\usage{
add_markers(map, data = get_map_data(map), id = NULL, colour = NULL,
  lat = NULL, lon = NULL, polyline = NULL, title = NULL,
  draggable = NULL, opacity = NULL, label = NULL, info_window = NULL,
  mouse_over = NULL, mouse_over_group = NULL, marker_icon = NULL,
  layer_id = NULL, cluster = FALSE, update_map_view = TRUE, digits = 4,
  load_interval = 0, focus_layer = FALSE)
}
\arguments{
\item{map}{a googleway map object created from \code{google_map()}}

\item{data}{data frame containing the data to use in the layer. If Null, the
data passed into \code{google_map()} will be used.}

\item{id}{string specifying the column containing an identifier for a shape}

\item{colour}{string specifying the column containing the 'colour' to use for
the markers. One of 'red', 'blue', 'green' or 'lavender'.}

\item{lat}{string specifying the column of \code{data} containing the 'latitude'
coordinates. If left NULL, a best-guess will be made}

\item{lon}{string specifying the column of \code{data} containing the 'longitude'
coordinates. If left NULL, a best-guess will be made}

\item{polyline}{string specifying the column of \code{data} containing the encoded polyline.
For circles and markers the encoded string will represent a single point.}

\item{title}{string specifying the column of \code{data} containing the 'title'
of the markers. The title is displayed when you hover over a marker. If blank,
no title will be displayed for the markers.}

\item{draggable}{string specifying the column of \code{data} defining if the
marker is 'draggable' (either TRUE or FALSE)}

\item{opacity}{string specifying the column of \code{data} defining the 'opacity'
of the maker. Values must be between 0 and 1 (inclusive).}

\item{label}{string specifying the column of \code{data} defining the character
to appear in the centre of the marker. Values will be coerced to strings, and
only the first character will be used.}

\item{info_window}{string specifying the column of data to display in an info
window when a shape is clicked.}

\item{mouse_over}{string specifying the column of data to display when the
mouse rolls over the shape}

\item{mouse_over_group}{string specifying the column of data specifying which
groups of shapes to highlight on mouseover}

\item{marker_icon}{string specifying the column of data containing a link/URL to
an image to use for a marker}

\item{layer_id}{single value specifying an id for the layer. Use this value to
distinguish between shape layers for when using any \code{update_} function, and
for separating legends.}

\item{cluster}{logical indicating if co-located markers should be clustered
when the map zoomed out}

\item{update_map_view}{logical specifying if the map should re-centre according to
the shapes}

\item{digits}{integer. Use this parameter to specify how many digits (decimal places)
should be used for the latitude / longitude coordinates.}

\item{load_interval}{time in miliseconds to wait between plotting each shape}

\item{focus_layer}{logical indicating if the map should re-centre according to this layer}
}
\description{
Add markers to a google map
}
\examples{
\dontrun{

map_key <- "your api key"

google_map(key = map_key, data = tram_stops) \%>\%
 add_markers(lat = "stop_lat", lon = "stop_lon", info_window = "stop_name")


## using marker icons
iconUrl <- paste0("https://developers.google.com/maps/documentation/",
"javascript/examples/full/images/beachflag.png")

tram_stops$icon <- iconUrl

google_map(key = map_key, data = tram_stops) \%>\%
  add_markers(lat = "stop_lat", lon = "stop_lon", marker_icon = "icon")

}
}
