% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gs_ws.R
\name{gs_ws_rename}
\alias{gs_ws_rename}
\title{Rename a worksheet within a spreadsheet}
\usage{
gs_ws_rename(ss, from = 1, to, verbose = TRUE)
}
\arguments{
\item{ss}{a registered Google spreadsheet, i.e. a \code{\link{googlesheet}}
object}

\item{from}{positive integer or character string specifying index or title,
respectively, of the worksheet}

\item{to}{character string for new title of worksheet}

\item{verbose}{logical; do you want informative messages?}
}
\value{
a \code{\link{googlesheet}} object
}
\description{
Give a worksheet a new title that does not duplicate the title of any
existing worksheet within the spreadsheet.
}
\note{
Since the edit link is used in the PUT request, the version path in the
  url changes everytime changes are made to the worksheet, hence consecutive
  function calls using the same edit link from the same sheet object without
  'refreshing' it by re-registering results in a HTTP 409 Conflict.
}
\examples{
\dontrun{
gap_ss <- gs_copy(gs_gap(), to = "gap_copy")
gs_ws_ls(gap_ss)
gap_ss <- gs_ws_rename(gap_ss, from = "Oceania", to = "ANZ")
gs_ws_ls(gap_ss)
gap_ss <- gs_ws_rename(gap_ss, from = 1, to = "I am the first sheet!")
gs_ws_ls(gap_ss)
gs_delete(gap_ss)
}

}

