% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/gs_add_row.R
\name{gs_add_row}
\alias{gs_add_row}
\title{Append a row to a spreadsheet}
\usage{
gs_add_row(ss, ws = 1, input = "", verbose = TRUE)
}
\arguments{
\item{ss}{a registered Google spreadsheet, i.e. a \code{\link{googlesheet}}
object}

\item{ws}{positive integer or character string specifying index or title,
respectively, of the worksheet}

\item{input}{new cell values, as an object that can be coerced into a
character vector, presumably an atomic vector, a factor, a matrix or a
data.frame}

\item{verbose}{logical; do you want informative messages?}
}
\description{
Add a row to an existing worksheet within an existing spreadsheet. This is
based on the
\href{https://developers.google.com/google-apps/spreadsheets/#working_with_list-based_feeds}{list
feed}, which has a strong assumption that the data occupies a neat rectangle
in the upper left corner of the sheet. This function specifically uses
\href{https://developers.google.com/google-apps/spreadsheets/#adding_a_list_row}{this
method}, which "inserts the new row immediately after the last row that
appears in the list feed, which is to say immediately before the first
entirely blank row."
}
\details{
At the moment, this function will only work in a sheet that has a proper
header row of variable or column names and at least one pre-existing data
row. If you get \code{Error : No matches}, that suggests the worksheet
doesn't meet these minimum requirements. In the future, we will try harder to
populate the sheet as necessary, e.g. create default variable names in a
header row and be able to cope with \code{input} being the first row of data.
}
\examples{
\dontrun{
yo <- gs_copy(gs_gap(), to = "yo")
yo <- gs_add_row(yo, ws = "Oceania",
                 input = c("Valinor", "Aman", "2015", "10000",
                           "35", "1000.5"))
tail(gs_read(yo, ws = "Oceania"))

gs_delete(yo)
}
}
\seealso{
\code{\link{gs_edit_cells}}
}

