% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dribble.R
\name{dribble-checks}
\alias{dribble-checks}
\alias{is_dribble}
\alias{no_file}
\alias{single_file}
\alias{some_files}
\alias{confirm_dribble}
\alias{confirm_single_file}
\alias{confirm_some_files}
\alias{is_folder}
\alias{is_native}
\alias{is_parental}
\alias{is_mine}
\alias{is_team_drive}
\alias{is_team_drivy}
\title{Check facts about a dribble}
\usage{
is_dribble(d)

no_file(d)

single_file(d)

some_files(d)

confirm_dribble(d)

confirm_single_file(d)

confirm_some_files(d)

is_folder(d)

is_native(d)

is_parental(d)

is_mine(d)

is_team_drive(d)

is_team_drivy(d)
}
\arguments{
\item{d}{A \code{\link{dribble}}.}
}
\description{
Sometimes you need to check things about a \code{\link{dribble}}` or about the files it
represents, such as:
\itemize{
\item Is it even a dribble?
\item Size: Does the dribble hold exactly one file? At least one file? No file?
\item File type: Is this file a folder?
\item File ownership and access: Is it mine? Published? Shared?
}
}
\examples{
\dontrun{
## most of us have multiple files or folders on Google Drive
d <- drive_find()
is_dribble(d)
no_file(d)
single_file(d)
some_files(d)
confirm_single_file(d)
confirm_some_files(d)
is_folder(d)
is_mine(d)
}
}
