% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/objects.R
\name{Object}
\alias{Object}
\title{Object Object}
\usage{
Object(acl = NULL, bucket = NULL, cacheControl = NULL,
  componentCount = NULL, contentDisposition = NULL,
  contentEncoding = NULL, contentLanguage = NULL, contentType = NULL,
  crc32c = NULL, customerEncryption = NULL, etag = NULL,
  generation = NULL, id = NULL, md5Hash = NULL, mediaLink = NULL,
  metadata = NULL, metageneration = NULL, name = NULL, owner = NULL,
  selfLink = NULL, size = NULL, storageClass = NULL, timeCreated = NULL,
  timeDeleted = NULL, updated = NULL)
}
\arguments{
\item{acl}{Access controls on the object}

\item{bucket}{The name of the bucket containing this object}

\item{cacheControl}{Cache-Control directive for the object data}

\item{componentCount}{Number of underlying components that make up this object}

\item{contentDisposition}{Content-Disposition of the object data}

\item{contentEncoding}{Content-Encoding of the object data}

\item{contentLanguage}{Content-Language of the object data}

\item{contentType}{Content-Type of the object data}

\item{crc32c}{CRC32c checksum, as described in RFC 4960, Appendix B; encoded using base64 in big-endian byte order}

\item{customerEncryption}{Metadata of customer-supplied encryption key, if the object is encrypted by such a key}

\item{etag}{HTTP 1}

\item{generation}{The content generation of this object}

\item{id}{The ID of the object}

\item{md5Hash}{MD5 hash of the data; encoded using base64}

\item{mediaLink}{Media download link}

\item{metadata}{User-provided metadata, in key/value pairs}

\item{metageneration}{The version of the metadata for this object at this generation}

\item{name}{The name of this object}

\item{owner}{The owner of the object}

\item{selfLink}{The link to this object}

\item{size}{Content-Length of the data in bytes}

\item{storageClass}{Storage class of the object}

\item{timeCreated}{The creation time of the object in RFC 3339 format}

\item{timeDeleted}{The deletion time of the object in RFC 3339 format}

\item{updated}{The modification time of the object metadata in RFC 3339 format}
}
\value{
Object object
}
\description{
Object Object
}
\details{
An object.
}
