% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/buildsteps_templates.R
\name{cr_buildstep_run}
\alias{cr_buildstep_run}
\title{Create buildsteps to deploy to Cloud Run}
\usage{
cr_buildstep_run(
  name,
  image,
  allowUnauthenticated = TRUE,
  region = cr_region_get(),
  concurrency = 80,
  port = NULL,
  max_instances = "default",
  memory = "256Mi",
  cpu = 1,
  env_vars = NULL,
  gcloud_args = NULL,
  ...
)
}
\arguments{
\item{name}{Name for deployment on Cloud Run}

\item{image}{The name of the image to create or use in deployment - \code{gcr.io}}

\item{allowUnauthenticated}{TRUE if can be reached from public HTTP address. If FALSE will configure a service-email called \code{(name)-cloudrun-invoker@(project-id).iam.gserviceaccount.com}}

\item{region}{The endpoint region for deployment}

\item{concurrency}{How many connections each container instance can serve. Can be up to 80.}

\item{port}{Container port to receive requests at. Also sets the $PORT environment variable. Must be a number between 1 and 65535, inclusive. To unset this field, pass the special value "default".}

\item{max_instances}{the desired maximum nuimber of container instances. "default" is 1000, you can get more if you requested a quota instance.  For Shiny instances on Cloud Run, this needs to be 1.}

\item{memory}{The format for size is a fixed or floating point number followed by a unit: G, M, or K corresponding to gigabyte, megabyte, or kilobyte, respectively, or use the power-of-two equivalents: Gi, Mi, Ki corresponding to gibibyte, mebibyte or kibibyte respectively. The default is 256Mi}

\item{cpu}{1 or 2 CPUs for your instance}

\item{env_vars}{Environment arguments passed to the Cloud Run container at runtime.  Distinct from \code{env} that run at build time.}

\item{gcloud_args}{a character string of arguments that can be sent to the gcloud command not covered by other parameters of this function}

\item{...}{passed on to \link{cr_buildstep}}
}
\description{
Create buildsteps to deploy to Cloud Run
}
\seealso{
Docs for \href{https://cloud.google.com/sdk/gcloud/reference/run/deploy}{gcloud run deploy this buildstep invokes}

Other Cloud Buildsteps: 
\code{\link{cr_buildstep_bash}()},
\code{\link{cr_buildstep_decrypt}()},
\code{\link{cr_buildstep_df}()},
\code{\link{cr_buildstep_docker}()},
\code{\link{cr_buildstep_edit}()},
\code{\link{cr_buildstep_extract}()},
\code{\link{cr_buildstep_gcloud}()},
\code{\link{cr_buildstep_gitsetup}()},
\code{\link{cr_buildstep_mailgun}()},
\code{\link{cr_buildstep_nginx_setup}()},
\code{\link{cr_buildstep_packagetests}()},
\code{\link{cr_buildstep_pkgdown}()},
\code{\link{cr_buildstep_r}()},
\code{\link{cr_buildstep_secret}()},
\code{\link{cr_buildstep_slack}()},
\code{\link{cr_buildstep_targets}()},
\code{\link{cr_buildstep}()}
}
\concept{Cloud Buildsteps}
