% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/yaml.R
\name{cr_build_yaml_secrets}
\alias{cr_build_yaml_secrets}
\title{Create an availableSecrets entry for build yaml}
\usage{
cr_build_yaml_secrets(
  secretEnv,
  secret,
  version = "latest",
  projectId = cr_project_get()
)
}
\arguments{
\item{secretEnv}{The name of the secretEnv that will be referred to in the build steps e.g. \code{'GH_TOKEN'}}

\item{secret}{The secret data name in Secret Manager}

\item{version}{The version of the secret}

\item{projectId}{The project to get the Secret from}
}
\description{
This creates the availabelSecrets entry for Builds so they can use Secret Manager environment arguments in the builds.
}
\examples{

cr_build_yaml_secrets("GH_TOKEN", "github_token")

s1 <- cr_build_yaml_secrets("USERNAME", "my_username")
s2 <- cr_build_yaml_secrets("PASSWORD", "my_password")

# use one $ in scripts to use the secretEnv (will be replaced by $$)
cr_build_yaml(
  steps = cr_buildstep(
    "docker",
    entrypoint = "bash",
    args = c(
      "-c",
      "docker login --username=$USERNAME --password=$PASSWORD"
    ),
    secretEnv = c("USERNAME", "PASSWORD")
  ),
  availableSecrets = list(s1, s2)
)
}
\seealso{
To download from Secret Manager to a file in a dedicated buildstep see \link{cr_buildstep_secret}.

\href{https://cloud.google.com/build/docs/securing-builds/use-secrets}{Using secrets from Secret Manager}

Other Cloud Build functions: 
\code{\link{Build}()},
\code{\link{RepoSource}()},
\code{\link{Source}()},
\code{\link{StorageSource}()},
\code{\link{cr_build_artifacts}()},
\code{\link{cr_build_list}()},
\code{\link{cr_build_logs}()},
\code{\link{cr_build_make}()},
\code{\link{cr_build_status}()},
\code{\link{cr_build_targets}()},
\code{\link{cr_build_upload_gcs}()},
\code{\link{cr_build_wait}()},
\code{\link{cr_build_write}()},
\code{\link{cr_build_yaml_artifact}()},
\code{\link{cr_build_yaml}()},
\code{\link{cr_build}()}
}
\concept{Cloud Build functions}
