## functions that build the functions....??

function_docs <- function(api_json_resource_method, api_json){
  
  order_names <- c(api_json_resource_method$parameterOrder, 
                   setdiff(names(api_json_resource_method$parameters), 
                           api_json_resource_method$parameterOrder))
  
  ## ensure order_names is a character vector
  order_names <- vapply(order_names, function(x) x, character(1), USE.NAMES = FALSE)
  if(!is.null(order_names) & !length(order_names) == 0){
    ordered_method_parameters <- api_json_resource_method$parameters[order_names]
  } else {
    ordered_method_parameters <- api_json_resource_method$parameters
  }

  
  params <- paste(collapse = "\n#' ", sep = "\n#'",
                  lapply(names(ordered_method_parameters), 
                         make_vars_description, 
                         api_json_resource_method=ordered_method_parameters)
  )
  
  ## add api objects
  if(!is.null(api_json_resource_method$request)){
    object_name <- api_json_resource_method$request[['$ref']]
    object_param_line <- paste0("#' @param ", 
                                object_name, 
                                " ",
                                "The \\link{",object_name,"} object to pass to this method\n")
    family_line <- paste0("#' @family ", object_name, " functions\n")
  } else {
    object_param_line <- NULL
    family_line <- NULL
  }
  
  docs <- paste0(
    "\t\n\n",
    "#' ", gsub("\n","",api_json_resource_method$description), "\n",
    "#' \n",
    "#' Autogenerated via \\code{\\link[googleAuthR]{gar_create_api_skeleton}}\n",
    "#' \n",
    "#' @seealso \\href{",api_json$documentationLink,"}{Google Documentation}\n",
    "#' \n",
    "#' @details \n",
    "#' Authentication scopes used by this function are:\n",
    "#' \\itemize{\n",
    "#'   \\item ", paste(api_json_resource_method$scopes, collapse = "\n#' \\item "),
    "\n#' }\n",
    "#' \n",
    "#' Set \\code{options(googleAuthR.scopes.selected = c(",paste(api_json_resource_method$scopes, collapse = ", "),")}\n",
    "#' Then run \\code{googleAuthR::gar_auth()} to authenticate.\n",
    "#' See \\code{\\link[googleAuthR]{gar_auth}} for details. \n",
    "#' \n",
    object_param_line,
    "#' ", params,
    "#' @importFrom googleAuthR gar_api_generator\n",
    family_line,
    "#' @export\n"
  )
  
  docs
}



object_docs <- function(properties_name, properties){
  
  excludes <- c("description_api","kind")
  prop <- properties[[properties_name]]
  
  if("description_api" %in% names(prop)){
    api_desc <- prop[["description_api"]]
  } else {
    api_desc <- "No description"
  }
  
  ## handle empty descriptions
  prop$description <- vapply(prop$description, function(x) if(x == "") "No description" else x, character(1))

  if(length(prop$description) > 0 && nchar(prop$description[[1]]) > 0){
    ## First sentence only
    prop_desc_names <- setdiff(names(prop[["description"]]), excludes)
    param_description <- first_sentence(prop[["description"]][prop_desc_names])
  } else {
    # param_description <- "No description was found for this argument"
    param_description <- NULL
  }

  object_childs <- get_object_children(properties_name, properties)
  param_names <- c(object_childs, setdiff(names(prop[["value"]]), excludes))
  
  if(!identical(object_childs, character(0))){
    param_description <- c(paste0("The \\link{", object_childs, "} object or list of objects"),
                           param_description)
  }

  if(length(param_names) > 0){
    params <- paste(collapse = "\n#' ", sep = "\n#'",
                    paste("@param", 
                          make.names(param_names),
                          param_description
                    )
    )
  } else {
    params <- NULL
  }

  
  docs <- paste0(
    "\t\n\n",
    "#' ", properties_name, " Object\n",
    "#' \n",
    "#' @details \n",
    "#' Autogenerated via \\code{\\link[googleAuthR]{gar_create_api_objects}}\n",
    "#' ", gsub("\n","",api_desc), "\n",
    "#' \n",
    "#' ", params,
    "\n",
    "#' \n",
    "#' @return ", properties_name, " object\n",
    "#' \n",
    paste0("#' @family ", first_sentence(properties_name), " functions\n"),
    "#' @export\n"
  )
  
  docs
}

function_params <- function(api_json_resource_method, api_json){
  
  order_names <- c(api_json_resource_method$parameterOrder, 
                   setdiff(names(api_json_resource_method$parameters), 
                           api_json_resource_method$parameterOrder))
  ## ensure order_names is a character vector
  order_names <- vapply(order_names, function(x) x, character(1), USE.NAMES = FALSE)
  
  if(!is.null(order_names) & !length(order_names) == 0){
    ordered_method_parameters <- api_json_resource_method$parameters[order_names]
  } else {
    ordered_method_parameters <- api_json_resource_method$parameters
  }
  
  ## add api objects
  if(!is.null(api_json_resource_method$request)){
    object_param_var <- api_json_resource_method$request[['$ref']]
    object_list <- list(list(name = object_param_var, required = TRUE))
    names(object_list) <- object_param_var
    ordered_method_parameters <- c(object_list, 
                                   ordered_method_parameters)
  }
  
  f_name <- gsub(paste0("^", api_json$name,"."), "", api_json_resource_method$id)
  make_f_arguments(f_name, ordered_method_parameters)
  
  
}

object_params <- function(properties_object_name, properties_object){
  arg_names <- properties_object[[properties_object_name]]$value
  object_childs <- get_object_children(properties_object_name, properties_object)
  names(object_childs) <- object_childs
  make_f_arguments(properties_object_name, 
                   c(object_childs, arg_names), 
                   exclude = c("description_api","kind"))
}

function_body <- function(api_json_resource_method, api_json){
  
  pars_list <- make_pars_list(api_json_resource_method)
  
  api_url <- make_api_url_string(api_json_resource_method, api_json)
  
  ## add api objects
  if(!is.null(api_json_resource_method$request)){
    object_param_var <- api_json_resource_method$request[['$ref']]
    
    function_call <- paste0("stopifnot(inherits(",object_param_var,", 'gar_",object_param_var,"'))\n\t\n",
                            "f(the_body = ", object_param_var,")\n\t\n")
  } else {
    function_call <- "f()\n\t\n"
  }
  
  fb <- paste0(
    api_url,
    "# ", api_json_resource_method$id,"\n",
    pars_list,"\n",
    "f <- googleAuthR::gar_api_generator(url, \n",
    "'",api_json_resource_method$httpMethod,"',",
    if(!is.null(pars_list)) "pars_args = rmNullObs(pars),\n" else "\n",
    "data_parse_function = function(x) x)\n\n",
    function_call,
    "\n",
    "}\n\n\n"
  )
  
  fb
  
}

object_body <- function(properties_name, properties){
  
  prop <- properties[[properties_name]]$value
  
  prop <- vapply(names(prop), function(x) if(prop[[x]] == "") make.names(x) else paste0('`',prop[[x]],'`'), character(1))
  object_childs <- get_object_children(properties_name, properties)
  names(object_childs) <- object_childs
  prop <- c(object_childs, prop)
  if(length(prop) == 0 ) return("list()\n\n}\n")

  paste0("\nstructure(list(", 
         paste(paste0("'",names(prop),"'"),
               prop,
               sep = " = ",
               collapse = ","), 
         "), class = '",paste0("gar_",properties_name),"')}\n")
  }


make_readme <- function(directory, api_json){
  
  filename <- file.path(directory, "README.md")
  package_name <- paste0("google",gsub("\\.","", make.names(api_json$id)),".auto")
  
  readme <- paste0("# ", package_name,"\n![](",api_json$icons$x32,")\n",
                   api_json$title," R library\n",
                   "\n",
                   api_json$description,"\nThis is an R package autogenerated via [googleAuthR](http://code.markedmondson.me/googleAuthR)'s Discovery API builder. \n",
                   "The Google Documentation for this API is [here](",api_json$documentationLink,").\n",
                   "\n",
                   "## Features \n",
                   " * Auto generated R functions for every method and object in the API\n",
                   " * Passes CRAN checks in skeleton form\n",
                   " * Auto-creates R package files via `usethis`\n",
                   " * Auto-documentation of function arguments\n",
                   " * Type-checking of passed objects\n",
                   " * Ability to quickly add new features of the API as they are published.\n",
                   "\n",
                   "## Authentication\n",
                   "Set the appropriate Google API scopes:\n\n```r\nlibrary(googleAuthR)\nlibrary(",
                   package_name, ")\noptions(googleAuthR.scopes.selected = c('",
                   paste(names(api_json$auth$oauth2$scopes), collapse = "', '"), "'))\n\ngar_auth()\n```",
                   "\n See the documentation for the package starting at `?", package_name, "`
## Useage\nThe intention is for these auto-generated packages to be used as a basis for proper R packages suitable for CRAN.\nFork this package, and then use the generated functions and objects to make what you need.\nThings you may want to do are:\n* Create parsing functions to make the API responses into more user-friendly forms\n* Create wrapper functions and objects around the API calls into more user-friendly forms\n* Create documentation, vignette's and examples\n"
    )
  
  add_line(readme, filename)
  
}
