% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shiny-modules-new.R
\name{accountPickerUI}
\alias{accountPickerUI}
\alias{accountPicker}
\title{accountPicker UI Shiny Module - pick GA4 accounts/webProperties in Shiny}
\usage{
accountPickerUI(id, width = NULL, inColumns = FALSE)

accountPicker(id, ga_table, id_only = TRUE)
}
\arguments{
\item{id}{Shiny id}

\item{width}{The width of the input}

\item{inColumns}{Whether to wrap selectInputs in width=4 columns}

\item{ga_table}{A table GA4 accounts/web properties from \code{ga_account_summary("ga4")}}

\item{id_only}{Whether to return just the id, not the row}
}
\value{
If id_only=FALSE, the row of ga_table for the selected GA4 web property e.g. use \code{ga_table$propertyId} to send to \link{ga_data} calls.  If id_only=TRUE, just the propertyId
}
\description{
Makes a dropdown row for use for authentication with GA4 web properties.

Shiny Module for use with \link{accountPickerUI}
}
\examples{

\dontrun{

ui <- fluidPage(title = "Shiny App",
                 accountPickerUI("auth_menu", inColumns = TRUE))
server <- function(input, output, session){
  token <- gar_shiny_auth(session)
  
  accs <- reactive({
    req(token)
    ga_account_list("ga4")
   })
   
  # module for authentication
  property_id <- accountPicker("auth_menu", ga_table = accs, id_only = TRUE)
 }
 
 shinyApp(gar_shiny_ui(ui, login_ui = silent_auth), server)

}
}
\seealso{
Other Shiny modules: 
\code{\link{authDropdownUI}()},
\code{\link{authDropdown}()},
\code{\link{metricDimensionSelectUI}()},
\code{\link{multi_selectUI}()},
\code{\link{multi_select}()}
}
\concept{Shiny modules}
