\name{gofKendallCvM}
\alias{gofKendallCvM}

\title{gof test (Cramer-von Mises) based on Kendall's process
}
\description{
\code{\link{gofKendallCvM}} tests a given dataset for a copula based on Kendall's process with the Cramer-von Mises test statistic. The margins can be estimated by a bunch of distributions and the time which is necessary for the estimation can be given. The possible copulae are \code{"normal"}, \code{"t"}, \code{"clayton"}, \code{"gumbel"} and \code{"frank"}. See for reference Genest et al. (2009). The parameter estimation is performed with pseudo maximum likelihood method. In case the estimation fails, inversion of Kendall's tau is used. The approximate p-values are computed with a parametric bootstrap, which computation can be accelerated by enabling in-build parallel computation.
}
\usage{
gofKendallCvM(copula, x, param = 0.5, param.est = TRUE, df = 4, df.est = TRUE, 
              margins = "ranks", M = 1000, dispstr = "ex", 
              lower = NULL, upper = NULL, 
              seed.active = NULL, processes = 1)
}
\arguments{
\item{copula}{
The copula to test for. Possible are the copulae \code{"normal"}, \code{"t"}, \code{"clayton"}, \code{"gumbel"} and \code{"frank"}.
}
  \item{x}{
A matrix containing the data with rows being observations and columns being variables.
}
\item{param}{
The copula parameter to use, if it shall not be estimated.
}
\item{param.est}{
Shall be either \code{TRUE} or \code{FALSE}. \code{TRUE} means that \code{param} will be estimated.
}
\item{df}{
Degrees of freedom, if not meant to be estimated. Only necessary if tested for \code{"t"}-copula. 
}
\item{df.est}{
Indicates if \code{df} shall be estimated. Has to be either \code{FALSE} or \code{TRUE}, where \code{TRUE} means that it will be estimated. 
}
\item{margins}{
Specifies which estimation method for the margins shall be used. The default is \code{"ranks"}, which is the standard approach to convert data in such a case. Alternatively the following distributions can be specified: \code{"beta"}, \code{"cauchy"}, Chi-squared (\code{"chisq"}), \code{"f"}, \code{"gamma"}, Log normal (\code{"lnorm"}), Normal (\code{"norm"}), \code{"t"}, \code{"weibull"}, Exponential (\code{"exp"}). Input can be either one method, e.g. \code{"ranks"}, which will be used for estimation of all data sequences. Also an individual method for each margin can be specified, e.g. \code{c("ranks", "norm", "t")} for 3 data sequences. If one does not want to estimate the margins, set it to \code{NULL}.
}
\item{M}{
Number of bootstrap samples.
}
\item{dispstr}{
A character string specifying the type of the symmetric positive definite matrix characterizing the elliptical copula. Implemented structures are "ex" for exchangeable and "un" for unstructured, see package \code{copula}.
}
\item{lower}{
Lower bound for the maximum likelihood estimation of the copula parameter. The constraint is also active in the bootstrapping procedure. The constraint is not active when a switch to inversion of Kendall's tau is necessary. Default \code{NULL}. 
}
\item{upper}{
Upper bound for the maximum likelihood estimation of the copula parameter. The constraint is also active in the bootstrapping procedure. The constraint is not active when a switch to inversion of Kendall's tau is necessary. Default \code{NULL}. 
}
\item{seed.active}{
Has to be either an integer or a vector of M+1 integers. If an integer, then the seeds for the bootstrapping procedure will be simulated. If M+1 seeds are provided, then these seeds are used in the bootstrapping procedure. Defaults to \code{NULL}, then \code{R} generates the seeds from the computer runtime. Controlling the seeds is useful for reproducibility of a simulation study to compare the power of the tests or for reproducibility of an empirical study.
}
\item{processes}{
The number of parallel processes which are performed to speed up the bootstrapping. Shouldn't be higher than the number of logical processors. Please see the details.}
}
\details{
With the pseudo observations \eqn{U_{ij}}{U[ij]} for \eqn{i = 1, \dots,n}{i = 1, ...,n}, \eqn{j = 1, \dots,d}{j = 1, ...,d} and \eqn{\mathbf{u} \in [0,1]^d}{u in [0,1]^d} is the empirical copula given by \eqn{C_n(\mathbf{u}) = \frac{1}{n} \sum_{i = 1}^n \mathbf{I}(U_{i1} \leq u_1, \dots, U_{id} \leq u_d).}{1/n sum(U[i1] <= u_1, ..., U[id] <= u_d, i = 1, ..., n).} Let the rescaled pseudo observations be \eqn{V_1 = C_n(U_1), \dots, V_n = C_n(U_n)}{V[1] = Cn(U[1]), ..., V[n] = Cn(U[n]} and the distribution function of \eqn{V}{V} shall be \eqn{K}. The estimated version is given by
\deqn{K_n(v) = \frac{1}{n} \sum_{i=1}^n \mathbf{I}(V_i \leq v)}{Kn(v) = 1/n sum(V[i] <= v, i = 1, ..., n)}
with \eqn{v \in [0,1]^d.}{v in [0,1]^d.}
The testable \eqn{H_0^{'}}{H0^'} hypothesis is then
\deqn{K \in \mathcal{K}_0 = \{K_{\theta} : \theta \in \Theta \}}{K in K_0 = {Ktheta : theta in Theta}}
with \eqn{\Theta}{Theta} being an open subset of \eqn{R^p}{R^p} for an integer \eqn{p \geq 1}{p >= 1}, see Genest et al. (2009). The resulting Cramer-von Mises test statistic is then given by
\deqn{T = n \int_0^1 (K_n(v) - K_{\theta_n})^2 d K_{\theta_n}(v).}{T = n int_0^1 (Kn(v) - Kthetan)^2 d Kthetan(v).}

Because \eqn{H_0^{'}}{H0^'} consists of more distributions than \eqn{H_0}{H0} the test is not necessarily consistent.

The approximate p-value is computed by the formula

\deqn{\sum_{b=1}^M \mathbf{I}(|T_b| \geq |T|) / M,}{sum(|T[b]| >= |T|, b=1, .., M) / M,}

For small values of \code{M}, initializing the parallelisation via \code{processes} does not make sense. The registration of the parallel processes increases the computation time. Please consider to enable parallelisation just for high values of \code{M}.

}
\value{
An object of the \code{class} gofCOP with the components
\item{method}{a character which informs about the performed analysis}
\item{copula}{the copula tested for}
\item{margins}{the method used to estimate the margin distribution.}
\item{param.margins}{the parameters of the estimated margin distributions. Only applicable if the margins were not specified as \code{"ranks"} or \code{NULL}.}
\item{theta}{dependence parameters of the copulae}
\item{df}{the degrees of freedem of the copula. Only applicable for t-copula.}
\item{res.tests}{a matrix with the p-values and test statistics of the hybrid and the individual tests}
}
\references{
Christian Genest, Bruno Remillard, David Beaudoin (2009). Goodness-of-fit tests for copulas: A review and a power study. \emph{Insurance: Mathematics and Economics, Volume 44, Issue 2, April 2009, Pages 199-213, ISSN 0167-6687}. \url{http://dx.doi.org/10.1016/j.insmatheco.2007.10.005}\cr \cr
Christian Genest, Jean-Francois Quessy, Bruno Remillard (2006). Goodness-of-fit Procedures for Copula Models Based on the Probability Integral Transformation. \emph{Scandinavian Journal of Statistics, Volume 33, Issue 2, 2006, Pages 337-366}. \url{http://dx.doi.org/10.1111/j.1467-9469.2006.00470.x}\cr \cr
Ulf Schepsmeier, Jakob Stoeber, Eike Christian Brechmann, Benedikt Graeler (2015). VineCopula: Statistical Inference of Vine Copulas. \emph{R package version 1.4.}. \url{https://cran.r-project.org/package=VineCopula}
}
\examples{
data(IndexReturns2D)

gofKendallCvM("normal", IndexReturns2D, M = 10)
}
