% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survmod.R
\name{parseCoxph}
\alias{parseCoxph}
\title{Parsing the survival formula and constructing all survival-related data objects.}
\usage{
parseCoxph(surv.formula, data)
}
\arguments{
\item{surv.formula}{A formula readable by `coxph`.#'}

\item{data}{a set of data containing covariate information for variables
named by `surv.formula`. Can be of any 'completeness', as the function 
returns a reduced set.}
}
\value{
A list containing 

* `survdata`: Reduced version of `data`, with only one row per subject, with covariates 
 specified by `surv.formula` along with survival time and failure status. 
* `ph`: model fit from `coxph`. 
* `n`: Number of unique subjects. 
* `Delta`: List of failure indicators for each subject (1=failed).
}
\description{
Parsing the survival formula and constructing all survival-related data objects.
}
\examples{

data = simData()$data
parseCoxph(Surv(survtime, status) ~ bin, data = data)
}
