#' @describeIn GMVAR Log-likelihood method
#' @inheritParams plot.gmvar
#' @param object object of class \code{'gmvar'} generated by \code{fitGMVAR()} or \code{GMVAR()}.
#' @export
logLik.gmvar <- function(object, ...) object$loglik


#' @describeIn GMVAR residuals method to extract multivariate quantile residuals
#' @inheritParams logLik.gmvar
#' @export
residuals.gmvar <- function(object, ...) {
  res <- object$quantile_residuals
  colnames(res) <- colnames(object$data)
  res
}


#' @describeIn GMVAR summary method
#' @inheritParams logLik.gmvar
#' @export
summary.gmvar <- function(object, ...) {
  gmvar <- object
  if(anyNA(gmvar$quantile_residuals)) {
    warning("Can't calculate all summaries without (non NA) quantile residuals! To add them, add data to your model with function add_data()!")
    qrtest <- NULL
  } else {
    qrtest <- quantile_residual_tests(gmvar, lags_ac=c(1, 5), lags_ch=c(1, 5), nsimu=1)
  }
  structure(list(gmvar=gmvar,
                 qrtest=qrtest,
                 regime_means=get_regime_means(gmvar)),
            class="gmvarsum")
}
