% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gmpoly.R
\name{gmpoly}
\alias{gmpoly}
\title{Define a multivariate polynomial}
\usage{
gmpoly(string, coeffs = NULL, powers = NULL)
}
\arguments{
\item{string}{a string such as \code{"x^(1,2,1) + 4 x^(0,2,3)"}, or you can 
define the polynomial with \code{coeffs} and \code{powers}; in this case
set \code{string} to \code{NULL} or to nothing (i.e. missing)}

\item{coeffs}{the coefficients of the polynomial, in case you don't define 
it with the \code{string} argument; this must be a vector of 
\code{\link[gmp]{bigq}} numbers}

\item{powers}{the powers of the polynomial, in case you don't define it 
with the \code{string} argument; this must be a matrix of integers, one 
row for each term (hence \code{nrow(powers)} must equal 
\code{length(coeffs)}), and the number of columns is the number of 
variables}
}
\value{
A \code{gmpoly} object.
}
\description{
Define a multivariate polynomial from a string or from its 
  coefficients and powers.
}
\examples{
library(gmpoly)
gmpoly("5/2 x^(2,3) + 3 x^(1,1)")
gmpoly("5/2 x^(2,3) - 3 x^(1,1)")
gmpoly("-x^(1,2,3) + 4/7 x^(3,1,1)")
library(gmp)
gmpoly(
  coeffs = as.bigq(c(5, 7), c(8, 9)), 
  powers = rbind(c(1, 1, 1), c(2, 2, 2))
)
}
