% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sampling.R
\name{sampling}
\alias{sampling}
\title{Sample a Gaussian mixture model}
\usage{
sampling(gmm, data_x = NULL, n = 1)
}
\arguments{
\item{gmm}{An object of class \code{gmm}.}

\item{data_x}{A data frame or numeric matrix containing observations of the
explanatory variables if conditional sampling is performed. Its columns must
explicitly be named after the explanatory variables. If \code{NULL} (the
default), joint sampling is performed.}

\item{n}{A non-negative integer corresponding to the number of samples. If
conditional sampling is performed, this argument is ignored.}
}
\value{
A numeric matrix containing the samples.
}
\description{
This function samples a Gaussian mixture model.
}
\examples{
set.seed(0)
data(gmm_body, data_body)
sampl_1 <- sampling(gmm_body, n = 500)
sampl_2 <- sampling(gmm_body,
                    data_body[, c("WEIGHT", "FAT", "HEIGHT", "AGE")])

}
\seealso{
\code{\link{density}}, \code{\link{expectation}}
}
