% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expectation.R
\name{expectation}
\alias{expectation}
\title{Compute expectations of a Gaussian mixture model}
\usage{
expectation(gmm, data_x = NULL)
}
\arguments{
\item{gmm}{An object of class \code{gmm}.}

\item{data_x}{A data frame or numeric matrix containing observations of the
explanatory variables if conditional expectations are computed. Its columns
must explicitly be named after the explanatory variables. If \code{NULL} (the
default), the joint expectation is computed in a one-row matrix.}
}
\value{
A numeric matrix containing the expectations.
}
\description{
This function computes expectations of a Gaussian mixture model.
}
\examples{
data(gmm_body, data_body)
expect_1 <- expectation(gmm_body)
expect_2 <- expectation(gmm_body,
                        data_body[, c("WEIGHT", "FAT", "HEIGHT", "AGE")])

}
\seealso{
\code{\link{density}}, \code{\link{sampling}}
}
