% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bart_functions.R
\name{cross_validate_model}
\alias{cross_validate_model}
\title{Cross-validation for BART model}
\usage{
cross_validate_model(data, folds, predictor_cols = NULL, seed = NULL)
}
\arguments{
\item{data}{Data frame with a column (named 'pa') indicating presence (1) or absence (0) and columns for the predictor variables.}

\item{folds}{A vector of fold assignments (same length as `data`).}

\item{predictor_cols}{Optional; a character vector of column names to be used as predictors. If NULL, all columns except 'pa' will be used.}

\item{seed}{Optional; random seed.}
}
\value{
A list with:
\describe{
  \item{metrics}{A data frame containing the true positives (TP), false positives (FP), false negatives (FN), true negatives (TN), and various performance metrics including precision (PREC), sensitivity (SEN), specificity (SPC), false discovery rate (FDR), negative predictive value (NPV), false negative rate (FNR), false positive rate (FPR), F-score, accuracy (ACC), balanced accuracy (BA), and true skill statistic (TSS) for each fold.}
  \item{predictions}{Data frame with observed, predicted, probability, and fold assignment per test instance.}
}
}
\description{
This function performs cross-validation for a Bayesian Additive Regression Trees (BART) model
using presence-absence data and environmental covariate layers. It calculates various performance metrics
for model evaluation.
}
