% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cv.glmnetr_230508.R
\name{cox.sat.dev}
\alias{cox.sat.dev}
\title{Calculate the CoxPH saturated log-likelihood}
\usage{
cox.sat.dev(y_, e_)
}
\arguments{
\item{y_}{Time variable for a survival analysis, whether or not there is a start time}

\item{e_}{Event indicator with 1 for event 0 otherwise.}
}
\value{
Saturated log likelihood for the Efron and Breslow approximations.
}
\description{
Calculate the saturated log-likelihood for the Cox 
model using both the Efron and Breslow approximations for the case where all ties
at a common event time have the same weights (exp(X*B)).  For 
the simple case without ties 
the saturated log-likelihood is 0 as the contribution to the log-likelihood at 
each event time point can be made arbitrarily close to 1 by assigning a much larger 
weight to the record with an 
event.  Similarly, in the case of ties 
one can assign a much larger weight to be associated with one of the event times 
such that the associated record contributes a 1 to the likelihood.  Next one 
can assign a very large weight to a second tie, but smaller than the first tie 
considered, and this too will contribute a 1 to the 
likelihood.  Continuing in this way for this and all time points with ties, 
the partial log-likelihood is 0, just like for the no-ties case.  Note, this is 
the same argument with which we derive the log-likelihood of 0 for the no ties
case. Still, to be consistent with others we derive the saturated log-likelihood
with ties under the constraint that all ties at each event time carry the same weights.
}
