% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BootGlmm.R
\name{BootGlmm}
\alias{BootGlmm}
\title{computes bootstrap resamples of your data,
stores estimates + SEs.}
\usage{
BootGlmm(base_model, resamples = 9999, base_data = NULL,
  return_coefs_instead = FALSE, resample_specific_blocks = NULL,
  unique_resample_lim = NULL, narrowness_avoid = TRUE,
  num_cores = DetectCores() - 1, suppress_sampling_message = FALSE,
  suppress_loading_bar = FALSE, allow_conv_error = FALSE)
}
\arguments{
\item{base_model}{The pre-bootstrap model, i.e. the model output
from running a standard model call.
Examples:
base_model <- glmmTMB(y ~ age + (1 | subj), data = rel_data, family = binomial)
base_model <- lm(y ~ x)
Assumes the data is accessible by
base_model$model (typical lm or glm), or
base_model$frame (works for glmmTMB), or
base_model@frame (works for lmer, glmer)
For now, if you have a different case, extract and send as base_data.}

\item{resamples}{How many resamples of your data do you want to do?
9999 is a reasonable default (see Hesterberg 2015),
but start very small to make sure it works on
your data properly, and to get a rough timing estimate etc.}

\item{base_data}{Default NULL; In a future version this will become mandatory to supply.
In some cases, it can be extracted
from the base_model, but this can produce bugs. It's recommended that
you supply your data.}

\item{return_coefs_instead}{Logical, default FALSE: do you want the list of lists
of results for each bootstrap sample (set to TRUE), or the
matrix output of all samples? See return for more details.}

\item{resample_specific_blocks}{Character vector, default NULL. If left NULL,
  this algorithm with choose ONE random block to resample over -
  the one with the largest entropy (often the one with most levels).
  If you wish to
  resample over specific random effects as blocks, enter
  the names here - can be one, or many. Note that resampling
  multiple blocks is in general quite conservative.

  If you want to perform case resampling but you do have
  random effects, set resample_specific_blocks to any
  non-null value that does not contain any random effect
  variable names.}

\item{unique_resample_lim}{Should be same length as number of random effects (or left NULL).
Do you want to force the resampling to produce a minimum number of
unique values in sampling? Don't make this too big...
Must be named same as rand cols}

\item{narrowness_avoid}{Boolean, default TRUE.
If TRUE, will resample n-1 instead of n elements
in the bootstrap (n being either rows, or random effect levels,
depending on existence of random effects). If FALSE, will do
typical size n resampling.}

\item{num_cores}{Defaults to detectCores() - 1 if parallel is loaded,
or just 1 if not. How many cores to use if doing parallel work?}

\item{suppress_sampling_message}{Logical, default FALSE. By default, this function
will message the console with the type of bootstrapping:
block resampling over random effects - in which case it'll say
what effect it's sampling over;
case resampling - in which case it'll say as much.
Set TRUE to hide message.}

\item{suppress_loading_bar}{Logical, default FALSE. If TRUE, uses standard
mclapply for parallel work, else uses pblapply (from pbapply),
which provides a nice loading bar for progress.}

\item{allow_conv_error}{logical, default FALSE; if the subsample runs but gives a convergence error,
is this acceptable? or should we resample?}
}
\value{
Returns the output from BootCI:
  a matrix of output for each fixed variable, including
  the intercept (estimate, CIs for boot and base, p-values).
  If return_coefs_instead = TRUE, then will instead
  return a list of length two:
  [[1]] will be a matrix containing the base
  estimates and standard errors.
  [[2]] will be a list of length resamples,
  each a matrix of estimates and standard errors.
  This output is useful for error checking, and if you want
  to run this function in a distributed way.
}
\description{
By default, this will compute bootstrap resamples and then send them to BootCI
for calculation. Note - only use parallel methods if your
model is expensive to build, otherwise the overhead won't be worth it.
}
\examples{
x <- rnorm(20)
y <- rnorm(20) + x
xy_data = data.frame(x = x, y = y)
first_model <- lm(y ~ x, data = xy_data)

out_matrix <- BootGlmm(first_model, 20, base_data = xy_data)
out_list <- BootGlmm(first_model, 20, base_data = xy_data, return_coefs_instead = TRUE)

\donttest{
  data(test_data)
  library(glmmTMB)
  test_formula <- as.formula('y ~ x_var1 + x_var2 + x_var3 + (1|subj)')
  test_model <- glmmTMB(test_formula, data = test_data, family = binomial)
  output_matrix <- BootGlmm(test_model, 199, base_data = test_data)

  output_lists <- BootGlmm(test_model, 199, base_data = test_data, return_coefs_instead = TRUE)
}
}
