% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glmmPen.R
\name{glmmPen}
\alias{glmmPen}
\title{Fit Penalized Generalized Mixed Models via Monte Carlo Expectation Conditional 
Minimization (MCECM)}
\usage{
glmmPen(
  formula,
  data = NULL,
  family = "binomial",
  covar = NULL,
  offset = NULL,
  fixef_noPen = NULL,
  penalty = c("MCP", "SCAD", "lasso"),
  alpha = 1,
  gamma_penalty = switch(penalty[1], SCAD = 4, 3),
  optim_options = optimControl(),
  adapt_RW_options = adaptControl(),
  trace = 0,
  tuning_options = selectControl(),
  BICq_posterior = NULL,
  progress = TRUE
)
}
\arguments{
\item{formula}{a two-sided linear formula object describing both the fixed effects and 
random effects part of the model, with the response on the left of a ~ operator and the terms, 
separated by + operators, on the right. Random-effects terms are distinguished by vertical bars 
("|") separating expression for design matrices from the grouping factor. \code{formula} should be 
of the same format needed for \code{\link[lme4]{glmer}} in package \pkg{lme4}. Only one grouping factor 
will be recognized. The random effects covariates need to be a subset of the fixed effects covariates.
The offset must be specified outside of the formula in the 'offset' argument.}

\item{data}{an optional data frame containing the variables named in \code{formula}. If \code{data} is 
omitted, variables will be taken from the environment of \code{formula}.}

\item{family}{a description of the error distribution and link function to be used in the model. 
Currently, the \code{glmmPen} algorithm allows the Binomial, Gaussian, and Poisson families
with canonical links only.}

\item{covar}{character string specifying whether the covariance matrix should be unstructured
("unstructured") or diagonal with no covariances between variables ("independent").
Default is set to \code{NULL}. If \code{covar} is set to \code{NULL} and the number of random effects
predictors (not including the intercept) is 
greater than or equal to 10 (i.e. high dimensional), then the algorithm automatically assumes an 
independent covariance structure and \code{covar} is set to "independent". Otherwise if \code{covar}
is set to \code{NULL} and the number of random effects predictors is less than 10, then the
algorithm automatically assumes an unstructured covariance structure and \code{covar} is set to "unstructured".}

\item{offset}{This can be used to specify an \emph{a priori} known component to be included in the 
linear predictor during fitting. Default set to \code{NULL} (no offset). If the data 
argument is not \code{NULL}, this should be a numeric vector of length equal to the 
number of cases (the length of the response vector). 
If the data argument specifies a data.frame, the offset
argument should specify the name of a column in the data.frame.}

\item{fixef_noPen}{Optional vector of 0's and 1's of the same length as the number of fixed effects covariates
used in the model. Value 0 indicates the variable should not have its fixed effect coefficient
penalized, 1 indicates that it can be penalized. Order should correspond to the same order of the 
fixed effects given in the formula.}

\item{penalty}{character describing the type of penalty to use in the variable selection procedure.
Options include 'MCP', 'SCAD', and 'lasso'. Default is MCP penalty. If the random effect covariance
matrix is "unstructured", then a group MCP, group SCAD, or group LASSO penalty is used on the 
random effects coefficients. See Breheny and Huang (2011) <doi:10.1214/10-AOAS388> 
and Breheny and Huang (2015) <doi:10.1007/s11222-013-9424-2> for details of these penalties.}

\item{alpha}{Tuning parameter for the Mnet estimator which controls the relative contributions 
from the MCP/SCAD/LASSO penalty and the ridge, or L2, penalty. \code{alpha=1} is equivalent to 
the MCP/SCAD/LASSO penalty, while \code{alpha=0} is equivalent to ridge regression. However,
\code{alpha=0} is not supported; \code{alpha} may be arbitrarily small, but not exactly zero}

\item{gamma_penalty}{The scaling factor of the MCP and SCAD penalties. Not used by LASSO penalty.
Default is 4.0 for SCAD and 3.0 for MCP. See Breheny and Huang (2011) <doi:10.1214/10-AOAS388> 
and Breheny and Huang (2015) <doi:10.1007/s11222-013-9424-2> for further details.}

\item{optim_options}{a structure of class "optimControl" created 
from function \code{\link{optimControl}} that specifies several optimization parameters. See the 
documentation for \code{\link{optimControl}} for more details on defaults.}

\item{adapt_RW_options}{a list of class "adaptControl" from function \code{\link{adaptControl}} 
containing the control parameters for the adaptive random walk Metropolis-within-Gibbs procedure. 
Ignored if \code{\link{optimControl}} parameter \code{sampler} is set to "stan" (default) or "independence".}

\item{trace}{an integer specifying print output to include as function runs. Default value is 0. 
See Details for more information about output provided when trace = 0, 1, or 2.}

\item{tuning_options}{a list of class "selectControl" or "lambdaControl" resulting from 
\code{\link{selectControl}} or \code{\link{lambdaControl}} containing additional control parameters.
When function \code{glmm} is used,the algorithm may be run using one specific set of
penalty parameters \code{lambda0} and \code{lambda1} by specifying such values in \code{lambdaControl()}. 
The default for \code{glmm} is to run the model fit with no penalization (\code{lambda0} = \code{lambda1} = 0).
When function \code{glmmPen} is run, \code{tuning_options} is specified using \code{selectControl()}. 
See the \code{\link{lambdaControl}} and \code{\link{selectControl}} documentation for further details.}

\item{BICq_posterior}{an optional character string expressing the path and file 
basename of a file combination that 
will file-back or currently file-backs a \code{big.matrix} of the posterior samples from the 
minimal penalty model used for the BIC-ICQ calculation used for model selection. T
(BIC-ICQ reference: Ibrahim et al (2011)
<doi:10.1111/j.1541-0420.2010.01463.x>). 
If this argument is
specified as \code{NULL} (default) and BIC-ICQ calculations are requested (see \code{\link{selectControl}})
for details), the posterior samples
will be saved in the file combination 'BICq_Posterior_Draws.bin' and 'BICq_Posterior_Draws.desc'
in the working directory.
See 'Details' section for additional details about the required format of \code{BICq_posterior}
and the file-backed big matrix.}

\item{progress}{a logical value indicating if additional output should be given showing the
progress of the fit procedure. If \code{TRUE}, such output includes iteration-level information
for the fit procedure (iteration number EM_iter,
number of MCMC samples nMC, average Euclidean distance between current coefficients and coefficients
from t--defined in \code{\link{optimControl}}--iterations back EM_conv, 
and number of non-zero fixed and random effects covariates
not including the intercept). Additionally, \code{progress = TRUE}
gives some other information regarding the progress of the variable selection 
procedure, including the model selection criteria and log-likelihood estimates
for each model fit.
Default is \code{TRUE}.}
}
\value{
A reference class object of class \code{\link{pglmmObj}} for which many methods are 
available (e.g. \code{methods(class = "pglmmObj")}, see ?pglmmObj for additional documentation)
}
\description{
\code{glmmPen} is used to fit penalized generalized mixed models via Monte Carlo Expectation 
Conditional Minimization (MCECM). The purpose of the function is to perform 
variable selection on both the fixed and random effects simultaneously for the
generalized linear mixed model. \code{glmmPen} selects the best model using 
BIC-type selection criteria (see \code{\link{selectControl}} documentation for 
further details)
}
\details{
Argument \code{BICq_posterior} details: If the \code{BIC_option} in \code{\link{selectControl}} 
(\code{tuning_options}) is specified 
to be 'BICq', this requests the calculation of the BIC-ICQ criterion during the selection
process. For the BIC-ICQ criterion to be calculated, a minimal penalty model assuming a small valued 
lambda penalty needs to be fit, and the posterior samples from this minimal penalty model need to be used. 
In order to avoid repetitive calculations of
this minimal penalty model (i.e. if secondary rounds of selection are desired in 
\code{\link{glmmPen_FineSearch}} or if the user wants to re-run \code{glmmPen} with a different
set of penalty parameters), a \code{big.matrix} of these 
posterior samples will be file-backed as two files: a backing file with extension '.bin' and a 
descriptor file with extension '.desc'. The \code{BICq_posterior} argument should contain a 
path and a filename of the form "./path/filename" such that the backingfile and
the descriptor file would then be saved as "./path/filename.bin" and "./path/filename.desc", respectively.
If \code{BICq_posterior} is set to \code{NULL}, then by default, the backingfile and descriptor
file are saved in the working directory as "BICq_Posterior_Draws.bin" and "BICq_Posterior_Draws.desc".
If the big matrix of posterior samples is already file-backed, \code{BICq_posterior} should
specify the path and basename of the appropriate files (again of form "./path/filename"); 
the minimal penalty model 
will not be fit again and the big.matrix of 
posterior samples will be read using the \code{attach.big.matrix} function of the
 \code{bigmemory} package and used in the BIC-ICQ 
calculations. If the appropriate files do not exist or \code{BICq_posterior} 
is specified as \code{NULL}, the minimal penalty model will be fit and the minimal penalty model posterior
samples will be saved as specified above. The algorithm will save 10^4 posterior samples automatically.
 
Trace details: The value of 0 (default) does not output any extra information. The value of 1
additionally outputs the updated coefficients, updated covariance matrix values, and the
number of coordinate descent iterations used for the M step for each
EM iteration. When pre-screening procedure is used and/or if the BIC-ICQ criterion is
requested, trace = 1 gives additional information about the penalties used
for the 'minimal penalty model' fit procedure. If Stan is not used as the E-step sampling mechanism, 
the value of 2 outputs all of the above plus gibbs acceptance rate information
for the adaptive random walk and independence samplers and the updated proposal standard deviation
for the adaptive random walk.
}
