% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{estimate_contrast}
\alias{estimate_contrast}
\alias{estimate_contrast.default}
\title{Point estimates of contrasts}
\usage{
estimate_contrast(model, contrast, method = NULL, ...)

\method{estimate_contrast}{default}(model, contrast, method = NULL, ...)
}
\arguments{
\item{model}{a fitted statistical model such as a glm or a coxph.}

\item{contrast}{numeric vector of the same length as the number of coefficients in the model; it describes the contrast \code{sum(contrast*fixcoef(model))}.}

\item{method}{character string value; specification of the algorithm used (implementation dependent). NULL must be accepted.
Suggested values are "ML" for maximum-likelihood, "REML" for restricted maximum-likelihood and "OLS" for ordinary least squares.}

\item{...}{Additional parameters that may be used by some implementations.}
}
\value{
A single numeric value (vector of length 1) equal to the point estimate of the contrast, with the name "pvalue".
}
\description{
This S3 generic function allows the computation of point estimates of contrasts
(i.e. linear combinations) of fixed-effects in many models
The default implementation computes Wald's confidence intervals with any model as long as it implements \code{\link{fixcoef}}, returning a vector of fixed effects.
}
\details{
This function should consistent with \code{\link{confint_contrast}} and \code{\link{p_value_contrast}} as they are designed to be used together.
If a null hypothesis (H0) is specified, it MUST be ignored by \code{estimate_contrast}.
If you want to make it consistent with p_value_contrast you may substract H0 from the output of \code{estimate_contrast} and \code{confint_contrast}.
}
\section{Methods (by class)}{
\itemize{
\item \code{default}: Compute contrasts of fixed-effects in any model implementing \code{\link{fixcoef}}.
It basically computes \code{sum(fixcoef(model) * contrast)}.
}}

\examples{
data(mtcars)
model1 = glm(family="gaussian", data=mtcars, hp ~ 0+factor(gear))
# do cars with 5 gears have more horse power (hp) than cars with 4 gears ?
estimate_contrast(model1, c(0,-1,1))

# now, we fit an equivalent model (same distribution and same predictions)
model2 = glm(family=gaussian(log), data=mtcars, hp ~ 0+factor(gear))

# do cars with 5 gears have at least twice the horse power than cars with 4 gears ?

estimate_contrast(model1, c(0,-1,0.5))

}
\seealso{
Other Contrast functions: 
\code{\link{confint_contrast}()},
\code{\link{estimate_confint_contrast}()},
\code{\link{p_value_contrast}()}
}
\concept{Contrast functions}
