% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glinvci.R
\name{clone_model}
\alias{clone_model}
\alias{clone_model.glinv_gauss}
\alias{clone_model.glinv}
\title{Clone a GLInv model}
\usage{
clone_model(mod, ...)

\method{clone_model}{glinv_gauss}(mod, ...)

\method{clone_model}{glinv}(mod, ...)
}
\arguments{
\item{mod}{An object of either \code{\link{glinv}} or \code{\link{glinv_gauss}} class.}

\item{...}{Further arguments to be passed to the S3 methods. Not used currently.}
}
\value{
A new model that is a clone of \code{mod}.
}
\description{
The \code{clone_model} function is a S3 generic method for either the \code{\link{glinv}}
or \code{\link{glinv_gauss}} class.
}
\details{
Because \code{glinv} or \code{glinv_gauss} object is mutable, the assignment \code{model2 = model1}
will not make a copy your model. The correct way to copy a model is to use the \code{clone_model}
function.
}
\examples{
repar = get_restricted_ou(H=NULL, theta=c(0,0), Sig='diag', lossmiss=NULL)
mod1 = glinv(tree    = ape::rtree(10),
             x0      = c(0,0),
             X       = NULL,
             repar   = repar)
mod2 = mod1
mod3 = clone_model(mod1)
traits = matrix(rnorm(20), 2, 10)
set_tips(mod1, traits)
print(has_tipvals(mod1))  # TRUE
print(has_tipvals(mod2))  # TRUE
print(has_tipvals(mod3))  # FALSE
}
