% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataset.r
\docType{data}
\name{nhanes}
\alias{nhanes}
\title{National Health and Nutrition Examination Survey 2015-2016}
\format{A data frame with 5735 observations on the following 8 variables.
\describe{
\item{\code{DPQ010}}{Have little interest in doing things}
\item{\code{DPQ020}}{Feeling down, depressed, or hopeless}
\item{\code{DPQ030}}{Trouble sleeping or sleeping too much}
\item{\code{DPQ040}}{Feeling tired or having little energy}
\item{\code{DPQ050}}{Poor appetite or overeating}
\item{\code{DPQ060}}{Feeling bad about yourself}
\item{\code{DPQ070}}{Trouble concentrating on things}
\item{\code{DPQ080}}{Moving or speaking slowly or too fast}
\item{\code{DPQ090}}{Thought you would be better off dead}
\item{\code{AGE}}{Age in years at screening}
\item{\code{GENDER}}{Respondent's Gender}
\item{\code{RACE}}{Race/Hispanic origin w/ NH Asian}
}}
\source{
\url{https://wwwn.cdc.gov/Nchs/Nhanes/}
}
\description{
There is a 9 manifest items about frequency of depression symptoms over the past 2 weeks from National Health and Nutrition Examination Survey (NHANES). All of 9 items are measured 4 point-scale, "Not at all", "Several days", "More than half the days", and "Nearly every day". Those four categories are converted to binary as "Yes" ("Nearly every day", "More than half the days", "Several days") and "No" ("Not at all"). The dataset includes gender, age, and race of respondents as covariates.
}
\examples{
data("nhanes")
# Model 1: LCA
lca = glca(item(starts.with = "DPQ") ~ 1, data = nhanes, nclass = 2)
summary(lca)

# Model 2: LCA with covariate(s)
lcr = glca(item(starts.with = "DPQ") ~ AGE, data = nhanes, nclass = 3)
summary(lcr)
coef(lcr)

# Model 3: MGLCA
mglca = glca(item(starts.with = "DPQ") ~ 1, group = GENDER,
             data = nhanes, nclass = 3)
summary(mglca)

# Model 4: MGLCA with covariate(s)
mglcr = glca(item(starts.with = "DPQ") ~ AGE, group = GENDER,
             data = nhanes, nclass = 3)
summary(mglcr)
coef(mglcr)

# Model 5: MLCA
mlca = glca(item(starts.with = "DPQ") ~ 1, group = RACE,
            data = nhanes, nclass = 3, ncluster = 2)
summary(mlca)
}
\references{
Centers for Disease Control and Prevention (CDC). National Center for Health Statistics (NCHS). National Health and Nutrition Examination Survey Data. Hyattsville, MD: U.S. Department of Health and Human Services, Centers for Disease Control and Prevention, [2015-2016][\url{https://wwwn.cdc.gov/nchs/nhanes/ContinuousNhanes/Default.aspx?BeginYear=2015}]
}
\keyword{datasets}
