% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/git2rdata_package.R
\docType{package}
\name{git2rdata-package}
\alias{git2rdata}
\alias{git2rdata-package}
\title{git2rdata: Store and Retrieve Data.frames in a Git Repository}
\description{
The git2rdata package is an R package for writing and reading
    dataframes as plain text files.  A metadata file stores important
    information.  1) Storing metadata allows to maintain the classes of
    variables.  By default, git2rdata optimizes the data for file storage.
    The optimization is most effective on data containing factors.  The
    optimization makes the data less human readable.  The user can turn
    this off when they prefer a human readable format over smaller files.
    Details on the implementation are available in vignette("plain_text",
    package = "git2rdata").  2) Storing metadata also allows smaller row
    based diffs between two consecutive commits.  This is a useful feature
    when storing data as plain text files under version control.  Details
    on this part of the implementation are available in
    vignette("version_control", package = "git2rdata").  Although we
    envisioned git2rdata with a git workflow in mind, you can use it in
    combination with other version control systems like subversion or
    mercurial.  3) git2rdata is a useful tool in a reproducible and
    traceable workflow.  vignette("workflow", package = "git2rdata") gives
    a toy example.  4) vignette("efficiency", package = "git2rdata")
    provides some insight into the efficiency of file storage, git
    repository size and speed for writing and reading.  Please cite using
    <doi:10.5281/zenodo.1485309>.
}
\seealso{
Useful links:
\itemize{
  \item \url{https://ropensci.github.io/git2rdata/}
  \item Report bugs at \url{https://github.com/ropensci/git2rdata/issues}
}

}
\author{
\strong{Maintainer}: Thierry Onkelinx \email{thierry.onkelinx@inbo.be} (\href{https://orcid.org/0000-0001-8804-4216}{ORCID})

Other contributors:
\itemize{
  \item Floris Vanderhaeghe \email{floris.vanderhaeghe@inbo.be} (\href{https://orcid.org/0000-0002-6378-6229}{ORCID}) [contributor]
  \item Peter Desmet \email{peter.desmet@inbo.be} (\href{https://orcid.org/0000-0002-8442-8025}{ORCID}) [contributor]
  \item Els Lommelen \email{els.lommelen@inbo.be} (\href{https://orcid.org/0000-0002-3481-5684}{ORCID}) [contributor]
  \item Research Institute for Nature and Forest \email{info@inbo.be} [copyright holder, funder]
}

}
\keyword{internal}
