% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/index.r
\docType{methods}
\name{add}
\alias{add}
\alias{add,git_repository,character-method}
\title{Add file(s) to index}
\usage{
add(repo, path)

\S4method{add}{git_repository,character}(repo, path)
}
\arguments{
\item{repo}{The repository \code{object}.}

\item{path}{character vector with filenames to add. The path must
be relative to the repository's working folder. Only non-ignored
files are added. If path is a directory, files in sub-folders are
added (if non-ignored)}
}
\value{
invisible(NULL)
}
\description{
Add file(s) to index
}
\examples{
\dontrun{
## Initialize a repository
path <- tempfile(pattern="git2r-")
dir.create(path)
repo <- init(path)

## Create a user
config(repo, user.name="Alice", user.email="alice@example.org")

## Create a file
writeLines("Hello world!", file.path(path, "file-to-add.txt"))

## Add file to repository
add(repo, "file-to-add.txt")

## View status of repository
status(repo)
}
}
\keyword{methods}

