% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diff.r
\docType{methods}
\name{show,git_diff-method}
\alias{show,git_diff-method}
\alias{show,git_diff-methods}
\title{Show a diff}
\usage{
\S4method{show}{git_diff}(object)
}
\arguments{
\item{object}{The diff \code{object}.}
}
\description{
Show a diff
}
\examples{
\dontrun{
## Initialize a repository
path <- tempfile(pattern="git2r-")
dir.create(path)
repo <- init(path)

## Config user
config(repo, user.name="Alice", user.email="alice@example.org")

## Create a file, add, commit
writeLines("Hello world!", file.path(path, "test.txt"))
add(repo, "test.txt")
commit(repo, "Commit message")

## Change the file
writeLines(c("Hello again!", "Here is a second line", "And a third"),
           file.path(path, "test.txt"))

## Brief summary of diff between index and workdir
diff(repo)
}
}
\keyword{methods}

