% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/blob.r
\docType{methods}
\name{length,git_blob-method}
\alias{length,git_blob-method}
\title{Size in bytes of the contents of a blob}
\usage{
\S4method{length}{git_blob}(x)
}
\arguments{
\item{x}{The blob \code{object}}
}
\value{
a non-negative integer
}
\description{
Size in bytes of the contents of a blob
}
\examples{
\dontrun{
## Initialize a temporary repository
path <- tempfile(pattern="git2r-")
dir.create(path)
repo <- init(path)

## Create a user
config(repo, user.name="Alice", user.email="alice@example.org")

## Commit a text file
writeLines("Hello world!", file.path(path, "example.txt"))
add(repo, "example.txt")
commit_1 <- commit(repo, "First commit message")
blob_1 <- tree(commit_1)["example.txt"]

## Get length in size of bytes of the content of the blob
length(blob_1)
}
}
\keyword{methods}

