% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/compute_tabulate.R
\name{compute_tabulate}
\alias{compute_tabulate}
\title{Count data at each location of a categorical variable}
\usage{
compute_tabulate(x, x_var, w_var = NULL)
}
\arguments{
\item{x}{Dataset-like object to count. Built-in methods for data frames,
grouped data frames and ggvis visualisations.}

\item{x_var,w_var}{Names of x and weight variables.}
}
\value{
A data frame with columns:
 \item{count_}{the number of points}
 \item{x_}{value of bin}
}
\description{
Count data at each location of a categorical variable
}
\examples{
library(dplyr)
# The tabulated column must be countable (not numeric)
\dontrun{mtcars \%>\% compute_tabulate(~cyl)}
mtcars \%>\% mutate(cyl = factor(cyl)) \%>\% compute_tabulate(~cyl)

# Or equivalently:
mtcars \%>\% compute_tabulate(~factor(cyl))

# If there's one weight value at each x, it effectively just renames columns.
pressure \%>\% compute_tabulate(~factor(temperature), ~pressure)

# It doesn't matter whether you transform inside or outside of a vis
mtcars \%>\% compute_tabulate(~factor(cyl)) \%>\%
  ggvis(x = ~x_, y = ~count_, y2 = 0) \%>\%
  layer_rects(width = band())

mtcars \%>\%
  ggvis(x = ~x_, y = ~count_, y2 = 0) \%>\%
  compute_tabulate(~factor(cyl)) \%>\%
  layer_rects(width = band())

# compute_tabulate is used automatically in layer_bars when no y prop
# is supplied.
mtcars \%>\% ggvis(x = ~factor(cyl)) \%>\% layer_bars()
}
\seealso{
\code{\link{compute_bin}} For counting cases within ranges of
  a continuous variable.

\code{\link{compute_count}} For counting cases at specific locations
  of a continuous variable. This is useful when the variable is continuous
  but the data is granular.
}

