% Generated by roxygen2 (4.0.1): do not edit by hand
\name{layer_histograms}
\alias{layer_freqpolys}
\alias{layer_histograms}
\title{Display binned data}
\usage{
layer_histograms(vis, ..., binwidth = NULL, origin = NULL, right = TRUE,
  stack = TRUE)

layer_freqpolys(vis, ..., binwidth = NULL, origin = NULL, right = TRUE)
}
\arguments{
\item{vis}{Visualisation to modify}

\item{...}{Visual properties used to override defaults.}

\item{stack}{If \code{TRUE}, will automatically stack overlapping bars.}

\item{binwidth}{The width of the bins. The default is \code{NULL}, which
yields 30 bins that cover the range of the data. You should always override
this value, exploring multiple widths to find the best to illustrate the
stories in your data.}

\item{origin}{The initial position of the left-most bin. If \code{NULL}, the
the default, will use the smallest value in the dataset.}

\item{right}{Should bins be right-open, left-closed, or
right-closed, left-open.}
}
\description{
Display binned data
}
\examples{
# Create histograms and frequency polygons with layers
mtcars \%>\% ggvis(~mpg) \%>\% layer_histograms()
mtcars \%>\% ggvis(~mpg) \%>\% layer_histograms(binwidth = 2)
mtcars \%>\% ggvis(~mpg) \%>\% layer_freqpolys(binwidth = 2)

# These are equivalent to combining compute_bin with the corresponding
# mark
mtcars \%>\% compute_bin(~mpg) \%>\% ggvis(~x_, ~count_) \%>\% layer_paths()

# With grouping
mtcars \%>\% ggvis(~mpg, fill = ~factor(cyl)) \%>\% group_by(cyl) \%>\%
  layer_histograms(binwidth = 2)
mtcars \%>\% ggvis(~mpg, stroke = ~factor(cyl)) \%>\% group_by(cyl) \%>\%
  layer_freqpolys(binwidth = 2)
}
\seealso{
\code{\link{layer_bars}} For bar graphs of counts at each unique
  x value, in contrast to a histogram's bins along x ranges.
}

