% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom-interpolate-tern.R,
%   R/stat-interpolate-tern.R
\docType{data}
\name{geom_interpolate_tern}
\alias{geom_interpolate_tern}
\alias{GeomInterpolateTern}
\alias{stat_interpolate_tern}
\alias{StatInterpolateTern}
\title{Ternary Interpolation}
\usage{
geom_interpolate_tern(
  mapping = NULL,
  data = NULL,
  stat = "InterpolateTern",
  position = "identity",
  ...,
  method = "auto",
  formula = value ~ poly(x, y, degree = 1),
  lineend = "butt",
  linejoin = "round",
  linemitre = 1,
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE
)

stat_interpolate_tern(
  mapping = NULL,
  data = NULL,
  geom = "interpolate_tern",
  position = "identity",
  ...,
  method = "auto",
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE,
  n = 80,
  formula = value ~ poly(x, y, degree = 1),
  base = "ilr"
)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[ggplot2:aes]{aes()}}. If specified and
\code{inherit.aes = TRUE} (the default), it is combined with the default mapping
at the top level of the plot. You must supply \code{mapping} if there is no plot
mapping.}

\item{data}{The data to be displayed in this layer. There are three
options:

If \code{NULL}, the default, the data is inherited from the plot
data as specified in the call to \code{\link[ggplot2:ggplot]{ggplot()}}.

A \code{data.frame}, or other object, will override the plot
data. All objects will be fortified to produce a data frame. See
\code{\link[ggplot2:fortify]{fortify()}} for which variables will be created.

A \code{function} will be called with a single argument,
the plot data. The return value must be a \code{data.frame}, and
will be used as the layer data. A \code{function} can be created
from a \code{formula} (e.g. \code{~ head(.x, 10)}).}

\item{position}{Position adjustment, either as a string naming the adjustment
(e.g. \code{"jitter"} to use \code{position_jitter}), or the result of a call to a
position adjustment function. Use the latter if you need to change the
settings of the adjustment.}

\item{...}{Other arguments passed on to \code{\link[ggplot2:layer]{layer()}}. These are
often aesthetics, used to set an aesthetic to a fixed value, like
\code{colour = "red"} or \code{size = 3}. They may also be parameters
to the paired geom/stat.}

\item{method}{Smoothing method (function) to use, accepts either
\code{NULL} or a character vector, e.g. \code{"lm"}, \code{"glm"}, \code{"gam"}, \code{"loess"}
or a function, e.g. \code{MASS::rlm} or \code{mgcv::gam}, \code{stats::lm}, or \code{stats::loess}.
\code{"auto"} is also accepted for backwards compatibility.  It is equivalent to
\code{NULL}.

For \code{method = NULL} the smoothing method is chosen based on the
size of the largest group (across all panels). \code{\link[stats:loess]{stats::loess()}} is
used for less than 1,000 observations; otherwise \code{\link[mgcv:gam]{mgcv::gam()}} is
used with \code{formula = y ~ s(x, bs = "cs")} with \code{method = "REML"}. Somewhat anecdotally,
\code{loess} gives a better appearance, but is \eqn{O(N^{2})}{O(N^2)} in memory,
so does not work for larger datasets.

If you have fewer than 1,000 observations but want to use the same \code{gam()}
model that \code{method = NULL} would use, then set
\verb{method = "gam", formula = y ~ s(x, bs = "cs")}.}

\item{formula}{Formula to use in smoothing function, eg. \code{y ~ x},
\code{y ~ poly(x, 2)}, \code{y ~ log(x)}. \code{NULL} by default, in which case
\code{method = NULL} implies \code{formula = y ~ x} when there are fewer than 1,000
observations and \code{formula = y ~ s(x, bs = "cs")} otherwise.}

\item{lineend}{Line end style (round, butt, square).}

\item{linejoin}{Line join style (round, mitre, bevel).}

\item{linemitre}{Line mitre limit (number greater than 1).}

\item{na.rm}{If \code{FALSE}, the default, missing values are removed with
a warning. If \code{TRUE}, missing values are silently removed.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[ggplot2:borders]{borders()}}.}

\item{geom, stat}{Use to override the default connection between
\code{geom_smooth()} and \code{stat_smooth()}.}

\item{n}{number of grid points in each direction}

\item{base}{the base transformation of the data, options include 'identity' (ie direct on the cartesian space), or 'ilr'
which means to use the isometric log ratio transformation.}
}
\description{
This is the heavily requested geometry for interpolating between ternary values, results being
rendered using contours on a ternary mesh.
}
\section{Aesthetics}{
 
\Sexpr[results=rd,stage=build]{ggtern:::rd_aesthetics("geom", "InterpolateTern")}
}

\examples{
data(Feldspar)
ggtern(Feldspar,aes(Ab,An,Or,value=T.C)) + 
stat_interpolate_tern(geom="polygon",
                     formula=value~x+y,
                     method=lm,n=100,
                     breaks=seq(0,1000,by=100),
                     aes(fill=..level..),expand=1) +
                     geom_point()
}
\author{
Nicholas Hamilton
}
\keyword{datasets}
