% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggsurvfit_build.R
\name{ggsurvfit_build}
\alias{ggsurvfit_build}
\title{Build 'ggsurvfit' Object}
\usage{
ggsurvfit_build(x, combine_plots = FALSE)
}
\arguments{
\item{x}{an object of class 'ggsurvfit' or 'ggcuminc'}

\item{combine_plots}{logical indicating whether to combine the primary plot
and the risk tables. When \code{TRUE}, plots are combined with \code{patchwork::wrap_plots()}.
When \code{FALSE} and the plot has risk tables, they are returned in a list of
gtable grobs.
Default is \code{FALSE}.}
}
\value{
a list of ggplot2 objects or a single ggplot2 object
}
\description{
Function takes an object created with \code{ggsurvfit()} or \code{ggcuminc()} and
prepares the plot for printing.
If a plot also has a risk table, this function will build the risk table
plots and return them either as list of plots or combined
using \code{patchwork::wrap_plots()}.
}
\examples{
# construct plot
p <-
  survfit2(Surv(time, status) ~ surg, df_colon) \%>\%
  ggsurvfit() +
  add_risktable() +
  ggplot2::scale_y_continuous(limits = c(0, 1))

# build plots
built_p <- ggsurvfit_build(p)

# combine plots
patchwork::wrap_plots(
  built_p[[1]],
  built_p[[2]],
  built_p[[3]],
  ncol = 1,
  heights = c(0.70, 0.15, 0.15)
)
}
