% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom-barh.R, R/geom-colh.R
\name{geom_barh}
\alias{geom_barh}
\alias{geom_colh}
\title{Bars, rectangles with bases on y-axis}
\usage{
geom_barh(
  mapping = NULL,
  data = NULL,
  stat = "counth",
  position = "stackv",
  ...,
  width = NULL,
  binwidth = NULL,
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE
)

geom_colh(
  mapping = NULL,
  data = NULL,
  position = "stackv",
  ...,
  width = NULL,
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE
)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[ggplot2:aes]{aes()}} or
\code{\link[ggplot2:aes_]{aes_()}}. If specified and \code{inherit.aes = TRUE} (the
default), it is combined with the default mapping at the top level of the
plot. You must supply \code{mapping} if there is no plot mapping.}

\item{data}{The data to be displayed in this layer. There are three
options:

If \code{NULL}, the default, the data is inherited from the plot
data as specified in the call to \code{\link[ggplot2:ggplot]{ggplot()}}.

A \code{data.frame}, or other object, will override the plot
data. All objects will be fortified to produce a data frame. See
\code{\link[ggplot2:fortify]{fortify()}} for which variables will be created.

A \code{function} will be called with a single argument,
the plot data. The return value must be a \code{data.frame}, and
will be used as the layer data. A \code{function} can be created
from a \code{formula} (e.g. \code{~ head(.x, 10)}).}

\item{stat}{Override the default connection between \code{geom_bar()} and
\code{stat_count()}.}

\item{position}{Position adjustment, either as a string, or the result of
a call to a position adjustment function.}

\item{...}{Other arguments passed on to \code{\link[ggplot2:layer]{layer()}}. These are
often aesthetics, used to set an aesthetic to a fixed value, like
\code{colour = "red"} or \code{size = 3}. They may also be parameters
to the paired geom/stat.}

\item{width}{Bar width. By default, set to 90\% of the resolution of the data.}

\item{binwidth}{\code{geom_bar()} no longer has a binwidth argument - if
you use it you'll get an warning telling to you use
\code{\link[ggplot2:geom_histogram]{geom_histogram()}} instead.}

\item{na.rm}{If \code{FALSE}, the default, missing values are removed with
a warning. If \code{TRUE}, missing values are silently removed.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[ggplot2:borders]{borders()}}.}
}
\description{
Horizontal version of \code{\link[ggplot2]{geom_bar}()}.
}
\section{Aesthetics}{

\code{geom_barh()} understands the following aesthetics (required aesthetics are in bold):
\itemize{
  \item \strong{\code{x}}
  \item \strong{\code{y}}
  \item \code{alpha}
  \item \code{colour}
  \item \code{fill}
  \item \code{group}
  \item \code{linetype}
  \item \code{size}
}
Learn more about setting these aesthetics in \code{vignette("ggplot2-specs")}.


\code{geom_colh()} understands the following aesthetics (required aesthetics are in bold):
\itemize{
  \item \strong{\code{y}}
  \item \strong{\code{x}}
  \item \code{alpha}
  \item \code{colour}
  \item \code{fill}
  \item \code{group}
  \item \code{linetype}
  \item \code{size}
}
Learn more about setting these aesthetics in \code{vignette("ggplot2-specs")}.
}

