% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggcolorchart.R
\name{color_chart}
\alias{color_chart}
\title{Create a color checker chart}
\usage{
color_chart(colors = grDevices::colors(), ncol = NULL, use.names = NULL,
  text.size = 2, text.color = NULL, grid.color = "white")
}
\arguments{
\item{colors}{character A vector of color definitions.}

\item{ncol}{integer Number of column in the checker grid.}

\item{use.names}{logical Force use of names or indexes.}

\item{text.size}{numeric Size of the text labels drawn on each color tile.}

\item{text.color}{character Color definition, used for text on tiles.}

\item{grid.color}{character Color definition, used for grid lines between
tiles.}
}
\description{
Color-checker-chart ggplot labelled with color names or with indexes of the
colors in the vector passed as first argument.
}
\note{
Default \code{text.color} uses \code{black_or_white()} to ensure enough
  contrast. Default for \code{use.names} depends on number of columns in the
  grid, indexes are used when columns are seven or more.
}
\examples{

color_chart()
color_chart(grep("dark", colors(), value = TRUE), text.size = 3.5)

}

