% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/discrete.09.futurama.R
\name{scale_color_futurama}
\alias{scale_color_futurama}
\alias{scale_colour_futurama}
\alias{scale_fill_futurama}
\title{The Futurama Color Scales}
\usage{
scale_color_futurama(palette = c("planetexpress"), alpha = 1, ...)

scale_colour_futurama(palette = c("planetexpress"), alpha = 1, ...)

scale_fill_futurama(palette = c("planetexpress"), alpha = 1, ...)
}
\arguments{
\item{palette}{Palette type.
Currently there is one available option: \code{"planetexpress"}
(12-color palette).}

\item{alpha}{Transparency level, a real number in (0, 1].
See \code{alpha} in \code{\link[grDevices]{rgb}} for details.}

\item{...}{additional parameters for \code{\link[ggplot2]{discrete_scale}}}
}
\description{
See \code{\link{pal_futurama}} for details.
}
\examples{
library("ggplot2")
data("diamonds")

ggplot(subset(diamonds, carat >= 2.2),
       aes(x = table, y = price, colour = cut)) +
  geom_point(alpha = 0.7) +
  geom_smooth(method = "loess", alpha = 0.1, size = 1, span = 1) +
  theme_bw() + scale_color_futurama()

ggplot(subset(diamonds, carat > 2.2 & depth > 55 & depth < 70),
       aes(x = depth, fill = cut)) +
  geom_histogram(colour = "black", binwidth = 1, position = "dodge") +
  theme_bw() + scale_fill_futurama()
}
\author{
Nan Xiao <\email{me@nanx.me}> |
<\href{http://nanx.me}{http://nanx.me}>
}

