% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stat_pvalue_manual.R
\name{stat_pvalue_manual}
\alias{stat_pvalue_manual}
\title{Add Manually P-values to a ggplot}
\usage{
stat_pvalue_manual(data, label = "p", y.position = "y.position",
  xmin = "group1", xmax = "group2", x = NULL, size = 3.88,
  label.size = size, bracket.size = 0.3, tip.length = 0.03,
  remove.bracket = FALSE, position = "identity", ...)
}
\arguments{
\item{data}{a data frame containing statitistical test results. The expected
default format should contain the following columns: \code{group1 | group2 |
p | y.position | etc}. \code{group1} and \code{group2} are the groups that
have been compared. \code{p} is the resulting p-value. \code{y.position} is
the y coordinates of the p-values in the plot.}

\item{label}{the column containing the label (e.g.: label = "p"). Default
value is "p", for p-value. Can be also an expression that can be formatted
by the \code{\link[glue]{glue}()} package. For example, when specifying
label = "t-test, p = \{p\}", the expression \{p\} will be replaced by its
value.}

\item{y.position}{column containing the coordinates (in data units) to be used
for absolute positioning of the label. Default value is "y.position". Can be
also a numeric vector.}

\item{xmin}{column containing the position of the left sides of the brackets.
Default value is "group1".}

\item{xmax}{(optional) column containing the position of the right sides of
the brackets. Default value is "group2". If NULL, the p-values are plotted
as a simple text.}

\item{x}{x position of the p-value. Should be used only when you want plot the
p-value as text (without brackets).}

\item{size, label.size}{size of label text.}

\item{bracket.size}{Width of the lines of the bracket.}

\item{tip.length}{numeric vector with the fraction of total height that the
bar goes down to indicate the precise column. Default is 0.03.}

\item{remove.bracket}{logical, if \code{TRUE}, brackets are removed from the
plot. Considered only in the situation, where comparisons are performed
against reference group or against "all".}

\item{position}{position adjustment, either as a string, or the result of a
call to a position adjustment function.}

\item{...}{other arguments passed on to \code{\link{layer}}. These are
often aesthetics, used to set an aesthetic to a fixed value, like
\code{color = "red"} or \code{size = 3}. They may also be parameters
to the paired geom/stat.}
}
\description{
Add manually p-values to a ggplot, such as box blots, dot plots
 and stripcharts.
}
\examples{

# T-test
stat.test <- compare_means(
 len ~ dose, data = ToothGrowth,
 method = "t.test"
)
stat.test

# Create a simple box plot
p <- ggboxplot(ToothGrowth, x = "dose", y = "len")
p

# Perform a t-test between groups
stat.test <- compare_means(
 len ~ dose, data = ToothGrowth,
 method = "t.test"
)
stat.test

# Add manually p-values from stat.test data
# First specify the y.position of each comparison
stat.test <- stat.test \%>\%
 mutate(y.position = c(29, 35, 39))
p + stat_pvalue_manual(stat.test, label = "p.adj")

# Customize the label with glue expression
# (https://github.com/tidyverse/glue)
p + stat_pvalue_manual(stat.test, label = "p = {p.adj}")


# Grouped bar plots
#\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%
ToothGrowth$dose <- as.factor(ToothGrowth$dose)
# Comparisons against reference
stat.test <- compare_means(
  len ~ dose, data = ToothGrowth, group.by = "supp",
  method = "t.test", ref.group = "0.5"
)
stat.test
# Plot
bp <- ggbarplot(ToothGrowth, x = "supp", y = "len",
                fill = "dose", palette = "jco",
                add = "mean_sd", add.params = list(group = "dose"),
                position = position_dodge(0.8))
bp + stat_pvalue_manual(
  stat.test, x = "supp", y.position = 33,
  label = "p.signif",
  position = position_dodge(0.8)
)

}
\seealso{
\code{\link{stat_compare_means}}
}
