% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stat-fit-broom.R
\name{stat_fit_tidy}
\alias{stat_fit_tidy}
\title{One row data frame with fitted parameter estimates}
\usage{
stat_fit_tidy(
  mapping = NULL,
  data = NULL,
  geom = "text_npc",
  method = "lm",
  method.args = list(formula = y ~ x),
  label.x = "left",
  label.y = "top",
  hstep = 0,
  vstep = NULL,
  position = "identity",
  na.rm = FALSE,
  show.legend = FALSE,
  inherit.aes = TRUE,
  ...
)
}
\arguments{
\item{mapping}{The aesthetic mapping, usually constructed with
\code{\link[ggplot2]{aes}} or \code{\link[ggplot2]{aes_}}. Only needs
to be set at the layer level if you are overriding the plot defaults.}

\item{data}{A layer specific dataset - only needed if you want to override
the plot defaults.}

\item{geom}{The geometric object to use display the data}

\item{method}{character.}

\item{method.args}{list of arguments to pass to \code{method}.}

\item{label.x, label.y}{\code{numeric} with range 0..1 or character.
Coordinates to be used for positioning the output, expressed in "normalized
parent coordinates" or character string. If too short they will be
recycled.}

\item{hstep, vstep}{numeric in npc units, the horizontal and vertical step
used between labels for different groups.}

\item{position}{The position adjustment to use for overlapping points on this
layer}

\item{na.rm}{a logical indicating whether NA values should be stripped
before the computation proceeds.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped. \code{FALSE}
never includes, and \code{TRUE} always includes.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics, rather
than combining with them. This is most useful for helper functions that
define both data and aesthetics and shouldn't inherit behaviour from the
default plot specification, e.g. \code{\link[ggplot2]{borders}}.}

\item{...}{other arguments passed on to \code{\link[ggplot2]{layer}}. This
can include aesthetics whose values you want to set, not map. See
\code{\link[ggplot2]{layer}} for more details.}
}
\description{
\code{stat_fit_tidy} fits a model and returns a "tidy" version
  of the model's summary, using package 'broom'. To add the summary in
  tabular form use \code{\link{stat_fit_tb}}. When using
  \code{stat_fit_tidy()} you will most likely want to change the default
  mapping for label.
}
\details{
\code{stat_fit_tidy} together with \code{\link{stat_fit_glance}}
  and \code{\link{stat_fit_augment}}, based on package 'broom' can be used
  with a broad range of model fitting functions as supported at any given
  time by 'broom'. In contrast to \code{\link{stat_poly_eq}} wich can
  generate text or expression labels automatically, for these functions the
  mapping of aesthetic \code{label} needs to be explicitly supplied in the
  call, and labels built on the fly.

  A ggplot statistic receives as data a data frame that is not the one passed
  as argument by the user, but instead a data frame with the variables mapped
  to aesthetics. In other words, it respects the grammar of graphics and
  consequently within arguments passed through \code{method.args} names of
  aesthetics like $x$ and $y$ should be used intead of the original variable
  names, while data is automatically passed the data frame. This helps ensure
  that the model is fitted to the same data as plotted in other layers.
}
\note{
The statistic \code{stat_fit_augment} can be used only with
  \code{methods} that accept formulas under any formal parameter name and a
  \code{data} argument. Use \code{ggplot2::stat_smooth()} instead of
  \code{stat_fit_augment} in production code if the additional features are
  not needed.
}
\section{Handling of grouping}{
 \code{stat_fit_tidy} applies the function
  given by \code{method} separately to each group of observations; in ggplot2
  factors mapped to aesthetics generate a separate group for each level.
  Because of this, \code{stat_fit_tidy} is not useful for annotating plots
  with results from \code{t.test()} or ANOVA or ANCOVA. In such cases use
  instead \code{stat_fit_tb()} which applies the model fitting per panel.
}

\section{Computed variables}{
 The output of \code{tidy()} is returned after
  reshaping it into a single row. Grouping is respected, and the model fit
  separatately to each group of data. The returned \code{data} object has one
  row for each group within a panel. To use the intercept, note that output
  of \code{tidy()} is renamed from \code{(Intercept)} to \code{Intercept}.

  To explore the values returned by this statistic, which vary depending
  on the model fitting function and model formula we suggest the use of
  \code{\link[gginnards]{geom_debug}}. An example is shown below.
}

\examples{
library(gginnards)
# Regression by panel, exploring computed variables with geom_debug()
ggplot(mtcars, aes(x = disp, y = mpg)) +
  stat_smooth(method = "lm") +
  geom_point(aes(colour = factor(cyl))) +
  stat_fit_tidy(method = "lm",
                method.args = list(formula = y ~ x),
                geom = "debug")

# Regression by panel example
ggplot(mtcars, aes(x = disp, y = mpg)) +
  stat_smooth(method = "lm") +
  geom_point(aes(colour = factor(cyl))) +
  stat_fit_tidy(method = "lm",
                label.x = "right",
                method.args = list(formula = y ~ x),
                mapping = aes(label = sprintf("Slope = \%.3g\np-value = \%.3g",
                                              stat(x_estimate),
                                              stat(x_p.value))))

# Regression by group example
ggplot(mtcars, aes(x = disp, y = mpg, colour = factor(cyl))) +
  stat_smooth(method = "lm") +
  geom_point() +
  stat_fit_tidy(method = "lm",
                label.x = "right",
                method.args = list(formula = y ~ x),
                mapping = aes(label = sprintf("Slope = \%.3g, p-value = \%.3g",
                                              stat(x_estimate),
                                              stat(x_p.value))))

# Weighted regression example
ggplot(mtcars, aes(x = disp, y = mpg, weight = cyl)) +
  stat_smooth(method = "lm") +
  geom_point(aes(colour = factor(cyl))) +
  stat_fit_tidy(method = "lm",
                label.x = "right",
                method.args = list(formula = y ~ x, weights = quote(weight)),
                mapping = aes(label = sprintf("Slope = \%.3g\np-value = \%.3g",
                                              stat(x_estimate),
                                              stat(x_p.value))))

}
\seealso{
\code{\link[broom]{broom}}

Other ggplot2 statistics based on 'broom'.: 
\code{\link{stat_fit_augment}()},
\code{\link{stat_fit_glance}()},
\code{\link{stat_fit_tb}()}
}
\concept{ggplot2 statistics based on 'broom'.}
