% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom-boxplot.r, R/stat-boxplot.r
\name{geom_boxplot}
\alias{geom_boxplot}
\alias{stat_boxplot}
\title{Box and whiskers plot.}
\usage{
geom_boxplot(mapping = NULL, data = NULL, stat = "boxplot",
  position = "dodge", ..., outlier.colour = NULL, outlier.color = NULL,
  outlier.shape = 19, outlier.size = 1.5, outlier.stroke = 0.5,
  notch = FALSE, notchwidth = 0.5, varwidth = FALSE, na.rm = FALSE,
  show.legend = NA, inherit.aes = TRUE)

stat_boxplot(mapping = NULL, data = NULL, geom = "boxplot",
  position = "dodge", ..., coef = 1.5, na.rm = FALSE, show.legend = NA,
  inherit.aes = TRUE)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link{aes}} or
\code{\link{aes_}}. If specified and \code{inherit.aes = TRUE} (the
default), it is combined with the default mapping at the top level of the
plot. You must supply \code{mapping} if there is no plot mapping.}

\item{data}{The data to be displayed in this layer. There are three
   options:

   If \code{NULL}, the default, the data is inherited from the plot
   data as specified in the call to \code{\link{ggplot}}.

   A \code{data.frame}, or other object, will override the plot
   data. All objects will be fortified to produce a data frame. See
   \code{\link{fortify}} for which variables will be created.

   A \code{function} will be called with a single argument,
   the plot data. The return value must be a \code{data.frame.}, and
   will be used as the layer data.}

\item{position}{Position adjustment, either as a string, or the result of
a call to a position adjustment function.}

\item{...}{other arguments passed on to \code{\link{layer}}. These are
often aesthetics, used to set an aesthetic to a fixed value, like
\code{color = "red"} or \code{size = 3}. They may also be parameters
to the paired geom/stat.}

\item{outlier.colour, outlier.color, outlier.shape, outlier.size, outlier.stroke}{Default aesthetics for outliers. Set to \code{NULL} to inherit from the
  aesthetics used for the box.

  In the unlikely event you specify both US and UK spellings of colour, the
  US spelling will take precedence.}

\item{notch}{if \code{FALSE} (default) make a standard box plot. If
\code{TRUE}, make a notched box plot. Notches are used to compare groups;
if the notches of two boxes do not overlap, this suggests that the medians
are significantly different.}

\item{notchwidth}{for a notched box plot, width of the notch relative to
the body (default 0.5)}

\item{varwidth}{if \code{FALSE} (default) make a standard box plot. If
\code{TRUE}, boxes are drawn with widths proportional to the
square-roots of the number of observations in the groups (possibly
weighted, using the \code{weight} aesthetic).}

\item{na.rm}{If \code{FALSE} (the default), removes missing values with
a warning.  If \code{TRUE} silently removes missing values.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link{borders}}.}

\item{geom, stat}{Use to override the default connection between
\code{geom_boxplot} and \code{stat_boxplot}.}

\item{coef}{length of the whiskers as multiple of IQR.  Defaults to 1.5}
}
\description{
The lower and upper "hinges" correspond to the first and third quartiles
(the 25th and 75th percentiles). This differs slightly from the method used
by the \code{boxplot} function, and may be apparent with small samples.
See \code{\link{boxplot.stats}} for for more information on how hinge
positions are calculated for \code{boxplot}.
}
\details{
The upper whisker extends from the hinge to the highest value that is within
1.5 * IQR of the hinge, where IQR is the inter-quartile range, or distance
between the first and third quartiles. The lower whisker extends from the
hinge to the lowest value within 1.5 * IQR of the hinge. Data beyond the
end of the whiskers are outliers and plotted as points (as specified by Tukey).

In a notched box plot, the notches extend \code{1.58 * IQR / sqrt(n)}.
This gives a roughly 95% confidence interval for comparing medians.
See McGill et al. (1978) for more details.
}
\section{Aesthetics}{

\Sexpr[results=rd,stage=build]{ggplot2:::rd_aesthetics("geom", "boxplot")}
}

\section{Computed variables}{

\describe{
  \item{width}{width of boxplot}
  \item{ymin}{lower whisker = smallest observation greater than or equal to lower hinge - 1.5 * IQR}
  \item{lower}{lower hinge, 25\% quantile}
  \item{notchlower}{lower edge of notch = median - 1.58 * IQR / sqrt(n)}
  \item{middle}{median, 50\% quantile}
  \item{notchupper}{upper edge of notch = median + 1.58 * IQR / sqrt(n)}
  \item{upper}{upper hinge, 75\% quantile}
  \item{ymax}{upper whisker = largest observation less than or equal to upper hinge + 1.5 * IQR}
}
}
\examples{
p <- ggplot(mpg, aes(class, hwy))
p + geom_boxplot()
p + geom_boxplot() + geom_jitter(width = 0.2)
p + geom_boxplot() + coord_flip()

p + geom_boxplot(notch = TRUE)
p + geom_boxplot(varwidth = TRUE)
p + geom_boxplot(fill = "white", colour = "#3366FF")
# By default, outlier points match the colour of the box. Use
# outlier.colour to override
p + geom_boxplot(outlier.colour = "red", outlier.shape = 1)

# Boxplots are automatically dodged when any aesthetic is a factor
p + geom_boxplot(aes(colour = drv))

# You can also use boxplots with continuous x, as long as you supply
# a grouping variable. cut_width is particularly useful
ggplot(diamonds, aes(carat, price)) +
  geom_boxplot()
ggplot(diamonds, aes(carat, price)) +
  geom_boxplot(aes(group = cut_width(carat, 0.25)))

\donttest{
# It's possible to draw a boxplot with your own computations if you
# use stat = "identity":
y <- rnorm(100)
df <- data.frame(
  x = 1,
  y0 = min(y),
  y25 = quantile(y, 0.25),
  y50 = median(y),
  y75 = quantile(y, 0.75),
  y100 = max(y)
)
ggplot(df, aes(x)) +
  geom_boxplot(
   aes(ymin = y0, lower = y25, middle = y50, upper = y75, ymax = y100),
   stat = "identity"
 )
}
}
\references{
McGill, R., Tukey, J. W. and Larsen, W. A. (1978) Variations of
    box plots. The American Statistician 32, 12-16.
}
\seealso{
\code{\link{stat_quantile}} to view quantiles conditioned on a
  continuous variable, \code{\link{geom_jitter}} for another way to look
  at conditional distributions.
}

