\name{stat_qq}
\alias{stat_qq}
\alias{StatQq}
\title{stat\_qq}
\description{Calculation for quantile-quantile plot}
\details{
This page describes stat\_qq, see \code{\link{layer}} and \code{\link{qplot}} for how to create a complete plot from individual components.
}
\section{Aesthetics}{
The following aesthetics can be used with stat\_qq.  Aesthetics are mapped to variables in the data with the \code{\link{aes}} function: \code{stat\_qq(\code{\link{aes}}(x = var))}
\itemize{
  \item \code{sample}: NULL (\strong{required}) 
  \item \code{x}: x position 
  \item \code{y}: y position 
}
}
\usage{stat_qq(mapping=NULL, data=NULL, geom="point", position="identity", quantiles=ppoints(length(data$sample)), distribution=qnorm, na.rm=FALSE, ...)}
\arguments{
 \item{mapping}{mapping between variables and aesthetics generated by aes}
 \item{data}{dataset used in this layer, if not specified uses plot dataset}
 \item{geom}{geometric used by this layer}
 \item{position}{position adjustment used by this layer}
 \item{quantiles}{Quantiles to compute and display}
 \item{distribution}{NULL}
 \item{na.rm}{NULL}
 \item{...}{Other arguments passed to distribution function}
}
\seealso{\itemize{
  \item \url{http://had.co.nz/ggplot2/stat_qq.html}
}}
\value{A \code{\link{layer}}}
\examples{\dontrun{
# From ?qqplot
y <- rt(200, df = 5)
qplot(sample = y, stat="qq")
qplot(sample = y, stat="qq", dist=qt, df=5)
qplot(sample = y, stat="qq", quantiles=seq(0,1, length=100))

df <- data.frame(y)
ggplot(y, aes(sample = y)) + stat_qq()
ggplot(y, aes(sample = y)) + geom_point(stat = "qq")

qplot(sample = precip, stat="qq")
}}
\author{Hadley Wickham, \url{http://had.co.nz/}}
\keyword{hplot}
