% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{geom_normalviolin}
\alias{geom_normalviolin}
\title{Creates normal violins with specified means and standard deviations}
\usage{
geom_normalviolin(mapping = NULL, data = NULL, nsigma = 4,
  p_tail = 0, p_lower_tail = p_tail/2, p_upper_tail = p_tail/2,
  tail_fill = "black", tail_alpha = 0.4, width = 0.6,
  upper_limit = NA, lower_limit = NA, face_left = TRUE,
  face_right = TRUE, na.rm = FALSE, show.legend = NA,
  inherit.aes = TRUE, ...)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[=aes]{aes()}} or
\code{\link[=aes_]{aes_()}}. If specified and \code{inherit.aes = TRUE} (the
default), it is combined with the default mapping at the top level of the
plot. You must supply \code{mapping} if there is no plot mapping.}

\item{data}{The data to be displayed in this layer. There are three
options:

If \code{NULL}, the default, the data is inherited from the plot
data as specified in the call to \code{\link[=ggplot]{ggplot()}}.

A \code{data.frame}, or other object, will override the plot
data. All objects will be fortified to produce a data frame. See
\code{\link[=fortify]{fortify()}} for which variables will be created.

A \code{function} will be called with a single argument,
the plot data. The return value must be a \code{data.frame}, and
will be used as the layer data. A \code{function} can be created
from a \code{formula} (e.g. \code{~ head(.x, 10)}).}

\item{nsigma}{The number of standard deviations each violin should extend}

\item{p_tail}{The 2-tailed proportion that should be highlighted. Can be overridden with p_lower_tail and/or p_upper_tail}

\item{p_lower_tail}{The proportion of the distribution that should be highlighted in the lower tail. Defaults to half of `p_tail`.}

\item{p_upper_tail}{The proportion of the distribution that should be highlighted in the upper tail. Defaults to half of `p_tail`.}

\item{tail_fill}{fill color for tails}

\item{tail_alpha}{alpha value for tails}

\item{width}{Width of normal violin}

\item{upper_limit}{upper limit for polygons. Needed in case setting limits in scale_y_continuous or ylim distorts the polygons.}

\item{lower_limit}{lower limit for polygons. Needed in case setting limits in scale_y_continuous or ylim distorts the polygons.}

\item{face_left}{Display left half of violins. Defaults to `TRUE`}

\item{face_right}{Display right half of violins. Defaults to `TRUE`}

\item{na.rm}{If \code{FALSE}, the default, missing values are removed with
a warning. If \code{TRUE}, missing values are silently removed.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[=borders]{borders()}}.}

\item{...}{Other arguments passed on to \code{\link[=layer]{layer()}}. These are
often aesthetics, used to set an aesthetic to a fixed value, like
\code{colour = "red"} or \code{size = 3}. They may also be parameters
to the paired geom/stat.}
}
\description{
Creates normal violins with specified means and standard deviations
}
\section{Aesthetics}{

\code{geom_normviolin} understands the following aesthetics (required aesthetics are in bold):
\itemize{
  \item \strong{x}
  \item \strong{mu} (mean of the normal distribution)
  \item \strong{sigma} (standard deviation of the normal distribution)
  \item width (width of violin)
  \item nsigma (number of standard deviations to which the violins extend)
  \item p_tail (2-tailed proportion of tails highlighted)
  \item p_upper_tail (proportion of upper tails highlighted)
  \item p_lower_tail (proportion of lower tails highlighted)
  \item face_left (display left half of violin?)
  \item face_right (display right half of violin?)
  \item color
  \item fill
  \item alpha (of fills)
  \item group
  \item linetype
  \item size (of lines)
}
}

\examples{
library(ggplot2)
library(ggnormalviolin)

d <- data.frame(
  Distribution = c("A", "B"),
  Distribution_mean = c(80, 90),
  Distribution_sd = c(15, 10)
)

ggplot(data = d, aes(x = Distribution)) +
  geom_normalviolin(aes(mu = Distribution_mean,
                      sigma = Distribution_sd))
}
