% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/operations.R
\name{ggml_sin}
\alias{ggml_sin}
\title{Sine (Graph)}
\usage{
ggml_sin(ctx, a)
}
\arguments{
\item{ctx}{GGML context}

\item{a}{Input tensor}
}
\value{
Tensor representing the sin operation
}
\description{
Creates a graph node for element-wise sine: sin(x)
}
\examples{
\donttest{
ctx <- ggml_init(16 * 1024 * 1024)
a <- ggml_new_tensor_1d(ctx, GGML_TYPE_F32, 4)
ggml_set_f32(a, c(0, pi/6, pi/2, pi))
result <- ggml_sin(ctx, a)
graph <- ggml_build_forward_expand(ctx, result)
ggml_graph_compute(ctx, graph)
output <- ggml_get_f32(result)  # [0, 0.5, 1, 0]
ggml_free(ctx)
}
}
