% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coord_sf_inset.R
\name{coord_sf_inset}
\alias{coord_sf_inset}
\title{Specify an inset configuration for the whole plot}
\usage{
coord_sf_inset(inset, ...)
}
\arguments{
\item{inset}{Inset configuration; see \code{\link[=configure_inset]{configure_inset()}}.}

\item{...}{Arguments passed to \code{\link[ggplot2:ggsf]{ggplot2::coord_sf()}}}
}
\value{
A ggplot coordinate object to be added to a plot.
}
\description{
This allows a default inset configuration to be provided to avoid having to
repeat it for each layer. Any layer that is inset-aware can use this as the
default configuration if none is specifically provided to that layer. This
coord also expands the axis limits to include the inset area.
}
\examples{
library(ggplot2)

nc <- sf::st_read(system.file("shape/nc.shp", package = "sf"), quiet = TRUE)

ggplot(nc) +
  geom_sf_inset(aes(fill = AREA)) +
  geom_inset_frame() +
  coord_sf_inset(inset = configure_inset(
    centre = sf::st_sfc(sf::st_point(c(-80, 35.5)), crs = 4326),
    scale = 1.5, translation = c(-50, -140), radius = 50, units = "mi"))
}
\seealso{
\code{\link[=geom_sf_inset]{geom_sf_inset()}}
}
